/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowComparator
implements Comparator<TvShow> {
    private Collator stringCollator;

    public TvShowComparator() {
        RuleBasedCollator defaultCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
        try {
            this.stringCollator = new RuleBasedCollator(defaultCollator.getRules().replace("<'_'", "<' '<'_'"));
        }
        catch (Exception e) {
            this.stringCollator = defaultCollator;
        }
    }

    @Override
    public int compare(TvShow tvShow1, TvShow tvShow2) {
        if (this.stringCollator != null) {
            String titleTvShow1 = StrgUtils.normalizeString(tvShow1.getTitleSortable().toLowerCase(Locale.ROOT));
            String titleTvShow2 = StrgUtils.normalizeString(tvShow2.getTitleSortable().toLowerCase(Locale.ROOT));
            return this.stringCollator.compare(titleTvShow1, titleTvShow2);
        }
        return tvShow1.getTitleSortable().toLowerCase(Locale.ROOT).compareTo(tvShow2.getTitleSortable().toLowerCase(Locale.ROOT));
    }
}

