/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.webvtt.sampleboxes;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.Box;
import org.mp4parser.IsoFile;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.CueIDBox;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.CuePayloadBox;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.CueSettingsBox;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.CueSourceIDBox;
import org.mp4parser.muxer.tracks.webvtt.sampleboxes.CueTimeBox;
import org.mp4parser.tools.IsoTypeWriter;

public class VTTCueBox
implements Box {
    CueSourceIDBox cueSourceIDBox;
    CueIDBox cueIDBox;
    CueTimeBox cueTimeBox;
    CueSettingsBox cueSettingsBox;
    CuePayloadBox cuePayloadBox;

    public long getSize() {
        return 8L + (this.cueSourceIDBox != null ? this.cueSourceIDBox.getSize() : 0L) + (this.cueIDBox != null ? this.cueIDBox.getSize() : 0L) + (this.cueTimeBox != null ? this.cueTimeBox.getSize() : 0L) + (this.cueSettingsBox != null ? this.cueSettingsBox.getSize() : 0L) + (this.cuePayloadBox != null ? this.cuePayloadBox.getSize() : 0L);
    }

    public void getBox(WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer header = ByteBuffer.allocate(8);
        IsoTypeWriter.writeUInt32((ByteBuffer)header, (long)this.getSize());
        header.put(IsoFile.fourCCtoBytes((String)this.getType()));
        writableByteChannel.write((ByteBuffer)((Buffer)header).rewind());
        if (this.cueSourceIDBox != null) {
            this.cueSourceIDBox.getBox(writableByteChannel);
        }
        if (this.cueIDBox != null) {
            this.cueIDBox.getBox(writableByteChannel);
        }
        if (this.cueTimeBox != null) {
            this.cueTimeBox.getBox(writableByteChannel);
        }
        if (this.cueSettingsBox != null) {
            this.cueSettingsBox.getBox(writableByteChannel);
        }
        if (this.cuePayloadBox != null) {
            this.cuePayloadBox.getBox(writableByteChannel);
        }
    }

    public CueSourceIDBox getCueSourceIDBox() {
        return this.cueSourceIDBox;
    }

    public void setCueSourceIDBox(CueSourceIDBox cueSourceIDBox) {
        this.cueSourceIDBox = cueSourceIDBox;
    }

    public CueIDBox getCueIDBox() {
        return this.cueIDBox;
    }

    public void setCueIDBox(CueIDBox cueIDBox) {
        this.cueIDBox = cueIDBox;
    }

    public CueTimeBox getCueTimeBox() {
        return this.cueTimeBox;
    }

    public void setCueTimeBox(CueTimeBox cueTimeBox) {
        this.cueTimeBox = cueTimeBox;
    }

    public CueSettingsBox getCueSettingsBox() {
        return this.cueSettingsBox;
    }

    public void setCueSettingsBox(CueSettingsBox cueSettingsBox) {
        this.cueSettingsBox = cueSettingsBox;
    }

    public CuePayloadBox getCuePayloadBox() {
        return this.cuePayloadBox;
    }

    public void setCuePayloadBox(CuePayloadBox cuePayloadBox) {
        this.cuePayloadBox = cuePayloadBox;
    }

    public String getType() {
        return "vtcc";
    }
}

