/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc.serializer;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.XMLRPCRuntimeException;
import de.timroes.axmlrpc.XMLUtil;
import de.timroes.axmlrpc.serializer.Serializer;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import de.timroes.axmlrpc.xmlcreator.XmlElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArraySerializer
implements Serializer {
    private static final String ARRAY_DATA = "data";
    private static final String ARRAY_VALUE = "value";
    private final SerializerHandler serializerHandler;

    public ArraySerializer(SerializerHandler serializerHandler) {
        this.serializerHandler = serializerHandler;
    }

    @Override
    public Object deserialize(Element content) throws XMLRPCException {
        ArrayList<Object> list = new ArrayList<Object>();
        Element data = XMLUtil.getOnlyChildElement(content.getChildNodes());
        if (!ARRAY_DATA.equals(data.getNodeName())) {
            throw new XMLRPCException("The array must contain one data tag.");
        }
        for (int i = 0; i < data.getChildNodes().getLength(); ++i) {
            Node value = data.getChildNodes().item(i);
            if (value == null || value.getNodeType() == 3 && value.getNodeValue().trim().length() <= 0 || value.getNodeType() == 8) continue;
            if (value.getNodeType() != 1) {
                throw new XMLRPCException("Wrong element inside of array.");
            }
            list.add(this.serializerHandler.deserialize((Element)value));
        }
        return list.toArray();
    }

    @Override
    public XmlElement serialize(Object object) {
        List<Object> iter = object instanceof Iterable ? (List<Object>)object : Arrays.asList((Object[])object);
        XmlElement array = new XmlElement("array");
        XmlElement data = new XmlElement(ARRAY_DATA);
        array.addChildren(data);
        try {
            for (Object t : iter) {
                XmlElement e = new XmlElement(ARRAY_VALUE);
                e.addChildren(this.serializerHandler.serialize(t));
                data.addChildren(e);
            }
        }
        catch (XMLRPCException ex) {
            throw new XMLRPCRuntimeException(ex);
        }
        return array;
    }
}

