/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.lastchange;

import java.util.ArrayList;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.support.lastchange.Event;
import org.jupnp.support.lastchange.EventedValue;
import org.jupnp.support.lastchange.InstanceID;
import org.jupnp.support.lastchange.LastChangeParser;

public class LastChange {
    private final Event event;
    private final LastChangeParser parser;
    private String previousValue;

    public LastChange(String s) {
        throw new UnsupportedOperationException("This constructor is only for service binding detection");
    }

    public LastChange(LastChangeParser parser, Event event) {
        this.parser = parser;
        this.event = event;
    }

    public LastChange(LastChangeParser parser) {
        this(parser, new Event());
    }

    public LastChange(LastChangeParser parser, String xml) throws Exception {
        this.event = xml != null && !xml.isEmpty() ? parser.parse(xml) : new Event();
        this.parser = parser;
    }

    public synchronized void reset() {
        this.previousValue = this.toString();
        this.event.clear();
    }

    public synchronized void setEventedValue(int instanceID, EventedValue<?> ... ev) {
        this.setEventedValue(new UnsignedIntegerFourBytes((long)instanceID), ev);
    }

    public synchronized void setEventedValue(UnsignedIntegerFourBytes instanceID, EventedValue<?> ... ev) {
        for (EventedValue<?> eventedValue : ev) {
            if (eventedValue == null) continue;
            this.event.setEventedValue(instanceID, eventedValue);
        }
    }

    public synchronized UnsignedIntegerFourBytes[] getInstanceIDs() {
        ArrayList<UnsignedIntegerFourBytes> list = new ArrayList<UnsignedIntegerFourBytes>();
        for (InstanceID instanceID : this.event.getInstanceIDs()) {
            list.add(instanceID.getId());
        }
        return list.toArray(new UnsignedIntegerFourBytes[list.size()]);
    }

    synchronized EventedValue<?>[] getEventedValues(UnsignedIntegerFourBytes instanceID) {
        InstanceID inst = this.event.getInstanceID(instanceID);
        return inst != null ? inst.getValues().toArray(new EventedValue[inst.getValues().size()]) : null;
    }

    public synchronized <EV extends EventedValue<?>> EV getEventedValue(int instanceID, Class<EV> type) {
        return this.getEventedValue(new UnsignedIntegerFourBytes((long)instanceID), type);
    }

    public synchronized <EV extends EventedValue<?>> EV getEventedValue(UnsignedIntegerFourBytes id, Class<EV> type) {
        return this.event.getEventedValue(id, type);
    }

    public synchronized void fire(PropertyChangeSupport propertyChangeSupport) {
        String lastChanges = this.toString();
        if (lastChanges != null && !lastChanges.isEmpty()) {
            propertyChangeSupport.firePropertyChange("LastChange", (Object)this.previousValue, (Object)lastChanges);
            this.reset();
        }
    }

    public synchronized String toString() {
        if (!this.event.hasChanges()) {
            return "";
        }
        try {
            return this.parser.generate(this.event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

