/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTvShowUIFilter;

public class TvShowLockedFilter
extends AbstractTvShowUIFilter {
    private JComboBox<LockedFlag> comboBox;

    @Override
    public String getId() {
        return "tvShowLocked";
    }

    @Override
    public String getFilterValueAsString() {
        try {
            return ((LockedFlag)((Object)this.comboBox.getSelectedItem())).name();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setFilterValue(Object value) {
        LockedFlag lockedFlag;
        if (value == null) {
            return;
        }
        if (value instanceof LockedFlag) {
            this.comboBox.setSelectedItem(value);
        } else if (value instanceof String && (lockedFlag = LockedFlag.valueOf((String)value)) != null) {
            this.comboBox.setSelectedItem((Object)lockedFlag);
        }
    }

    @Override
    public void clearFilter() {
        this.comboBox.setSelectedItem((Object)this.comboBox.getItemAt(0));
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        return invert ^ tvShow.isLocked() == (this.comboBox.getSelectedItem() == LockedFlag.LOCKED);
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.locked"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.comboBox = new JComboBox<LockedFlag>(LockedFlag.values());
        return this.comboBox;
    }

    private static enum LockedFlag {
        LOCKED(TmmResourceBundle.getString("metatag.locked")),
        NOT_LOCKED(TmmResourceBundle.getString("metatag.unlocked"));

        private final String title;

        private LockedFlag(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

