/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.Comparator;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.AbstractTmmTreeTableNodeComparator;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableSortingStrategy;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;

class TvShowTreeNodeComparator
extends AbstractTmmTreeTableNodeComparator {
    private final Comparator stringComparator;
    private final TmmTreeTableFormat<TmmTreeNode> tableFormat;
    private Comparator sortComparator;

    TvShowTreeNodeComparator(TmmTreeTableFormat<TmmTreeNode> tableFormat) {
        this.tableFormat = tableFormat;
        this.stringComparator = new TmmTableFormat.StringComparator();
        this.sortColumn = 0;
        this.sortDirection = ITmmTreeTableSortingStrategy.SortDirection.ASCENDING;
        this.sortComparator = this.getSortComparator();
    }

    @Override
    public int compare(TmmTreeNode o1, TmmTreeNode o2) {
        Object userObject1 = o1.getUserObject();
        Object userObject2 = o2.getUserObject();
        if (userObject1 instanceof TvShow && userObject2 instanceof TvShow) {
            int compairingResult = this.sortComparator.compare(this.getColumnValue(o1, this.sortColumn), this.getColumnValue(o2, this.sortColumn));
            if (compairingResult == 0 && this.sortColumn != 0) {
                compairingResult = this.stringComparator.compare(this.getColumnValue(o1, 0), this.getColumnValue(o2, 0));
            } else if (this.sortDirection == ITmmTreeTableSortingStrategy.SortDirection.DESCENDING) {
                compairingResult *= -1;
            }
            return compairingResult;
        }
        if (userObject1 instanceof TvShowSeason && userObject2 instanceof TvShowSeason) {
            TvShowSeason tvShowSeason1 = (TvShowSeason)userObject1;
            TvShowSeason tvShowSeason2 = (TvShowSeason)userObject2;
            return tvShowSeason1.getSeason() - tvShowSeason2.getSeason();
        }
        if (userObject1 instanceof TvShowEpisode && userObject2 instanceof TvShowEpisode) {
            TvShowEpisode tvShowEpisode1 = (TvShowEpisode)userObject1;
            TvShowEpisode tvShowEpisode2 = (TvShowEpisode)userObject2;
            return tvShowEpisode1.getEpisode() - tvShowEpisode2.getEpisode();
        }
        return o1.toString().compareToIgnoreCase(o2.toString());
    }

    @Override
    public void columnClicked(int column, boolean shift, boolean control) {
        this.sortDirection = this.sortColumn == column ? (this.sortDirection == ITmmTreeTableSortingStrategy.SortDirection.ASCENDING ? ITmmTreeTableSortingStrategy.SortDirection.DESCENDING : ITmmTreeTableSortingStrategy.SortDirection.ASCENDING) : ITmmTreeTableSortingStrategy.SortDirection.ASCENDING;
        this.sortColumn = column;
        this.sortComparator = this.getSortComparator();
    }

    @Override
    public void fromString(String stringEncoded) {
        super.fromString(stringEncoded);
        this.sortComparator = this.getSortComparator();
    }

    private Comparator getSortComparator() {
        if (this.sortColumn == 0) {
            return this.stringComparator;
        }
        return this.tableFormat.getColumnComparator(this.sortColumn - 1);
    }

    private Object getColumnValue(TmmTreeNode treeNode, int i) {
        if (i == 0) {
            return ((TvShow)treeNode.getUserObject()).getTitleSortable();
        }
        return this.tableFormat.getColumnValue(treeNode, i - 1);
    }

    @Override
    public ITmmTreeTableSortingStrategy.SortDirection getSortDirection(int sortColumn) {
        if (sortColumn == this.sortColumn) {
            return this.sortDirection;
        }
        return null;
    }
}

