/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieScrapeTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieScrapeMetadataDialog;

public class MovieSelectedScrapeMetadataAction
extends TmmAction {
    public MovieSelectedScrapeMetadataAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.scrape.metadata"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.scrape.metadata.desc"));
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            return;
        }
        MovieScrapeMetadataDialog dialog = new MovieScrapeMetadataDialog(TmmResourceBundle.getString("movie.scrape.metadata"));
        dialog.setLocationRelativeTo(MainWindow.getInstance());
        dialog.setVisible(true);
        MovieSearchAndScrapeOptions options = dialog.getMovieSearchAndScrapeOptions();
        List<MovieScraperMetadataConfig> config = dialog.getMovieScraperMetadataConfig();
        boolean overwrite = dialog.getOverwriteExistingItems();
        if (dialog.shouldStartScrape()) {
            MovieScrapeTask scrapeTask = new MovieScrapeTask(new MovieScrapeTask.MovieScrapeParams(selectedMovies, options, config).setDoSearch(false).setOverwriteExistingItems(overwrite));
            TmmTaskManager.getInstance().addMainTask(scrapeTask);
        }
    }
}

