/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.index;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.tinymediamanager.library.bluray.index.AppInfoBDMV;
import org.tinymediamanager.library.bluray.index.ExtensionData;
import org.tinymediamanager.library.bluray.index.IndexWriter;
import org.tinymediamanager.library.bluray.index.Indexes;
import org.tinymediamanager.library.bluray.index.StringIOHelper;

@XmlRootElement
public class Index {
    String type;
    String version;
    AppInfoBDMV appInfo = new AppInfoBDMV();
    Indexes indexes = new Indexes();
    ExtensionData extensionData = new ExtensionData();
    int paddingN1;
    int paddingN2;
    int paddingN3;
    short[] n1;
    short[] n2;
    short[] n3;

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setAppInfo(AppInfoBDMV appInfoBDMV) {
        this.appInfo = appInfoBDMV;
    }

    public AppInfoBDMV getAppInfo() {
        return this.appInfo;
    }

    public void setIndexes(Indexes indexes) {
        this.indexes = indexes;
    }

    public Indexes getIndexes() {
        return this.indexes;
    }

    public void setExtensionData(ExtensionData extensionData) {
        this.extensionData = extensionData;
    }

    public ExtensionData getExtensionData() {
        return this.extensionData;
    }

    public void setPaddingN1(int n) {
        this.paddingN1 = n;
    }

    public int getPaddingN1() {
        return this.paddingN1;
    }

    public void setPaddingN1Data(short[] sArray) {
        this.n1 = sArray;
    }

    public short[] getPaddingN1Data() {
        return this.n1;
    }

    public void setPaddingN2(int n) {
        this.paddingN2 = n;
    }

    public int getPaddingN2() {
        return this.paddingN2;
    }

    public void setPaddingN2Data(short[] sArray) {
        this.n2 = sArray;
    }

    public short[] getPaddingN2Data() {
        return this.n2;
    }

    public void setPaddingN3(int n) {
        this.paddingN3 = n;
    }

    public int getPaddingN3() {
        return this.paddingN3;
    }

    public void setPaddingN3Data(short[] sArray) {
        this.n3 = sArray;
    }

    public short[] getPaddingN3Data() {
        return this.n3;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        String string = StringIOHelper.readISO646String(dataInputStream, 4);
        String string2 = StringIOHelper.readISO646String(dataInputStream, 4);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        if (!"INDX".equals(string)) {
            throw new RuntimeException("TypeIndicator error " + string);
        }
        this.setVersion(string2);
        dataInputStream.skipBytes(24);
        int n3 = n - 40;
        byte[] byArray = new byte[n3];
        dataInputStream.read(byArray);
        DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
        this.appInfo.readObject(dataInputStream2);
        this.n1 = this.seekPaddings(dataInputStream2);
        this.setPaddingN1(this.n1.length);
        dataInputStream2.close();
        if (n2 == 0) {
            this.indexes.readObject(dataInputStream);
            this.n2 = this.seekPaddings(dataInputStream);
            this.setPaddingN2(this.n2.length);
            this.setPaddingN3(0);
            return;
        }
        int n4 = n2 - n;
        byte[] byArray2 = new byte[n4];
        dataInputStream.read(byArray2);
        DataInputStream dataInputStream3 = new DataInputStream(new ByteArrayInputStream(byArray2));
        this.indexes.readObject(dataInputStream3);
        this.n2 = this.seekPaddings(dataInputStream3);
        this.setPaddingN2(this.n2.length);
        dataInputStream3.close();
        this.extensionData = new ExtensionData();
        this.extensionData.readObject(dataInputStream);
        this.n3 = this.seekPaddings(dataInputStream);
        this.setPaddingN3(this.n3.length);
    }

    public String toXML() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            new IndexWriter().writeXml(this, dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[24];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream2);
        this.appInfo.writeObject(dataOutputStream2);
        if (this.paddingN1 != 0) {
            for (n = 0; n < this.paddingN1; ++n) {
                dataOutputStream2.writeShort(this.n1[n]);
            }
        }
        this.indexes.writeObject(dataOutputStream3);
        if (this.paddingN2 != 0) {
            for (n = 0; n < this.paddingN2; ++n) {
                dataOutputStream2.write(this.n2[n]);
            }
        }
        dataOutputStream2.flush();
        dataOutputStream3.flush();
        int n2 = 40 + dataOutputStream2.size();
        int n3 = this.extensionData.getData() == null ? 0 : n2 + dataOutputStream3.size();
        dataOutputStream.write(StringIOHelper.getISO646Bytes("INDX"));
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getVersion()));
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
        dataOutputStream.write(byteArrayOutputStream2.toByteArray());
        if (this.extensionData.getData() != null) {
            this.extensionData.writeObject(dataOutputStream);
        }
        if (this.paddingN3 != 0) {
            for (n = 0; n < this.paddingN3; ++n) {
                dataOutputStream2.writeShort(this.n3[n]);
            }
        }
        dataOutputStream2.close();
        dataOutputStream3.close();
    }

    private short[] seekPaddings(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        short[] sArray = new short[1024];
        try {
            sArray[n] = (short)dataInputStream.readUnsignedShort();
            ++n;
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return Arrays.copyOf(sArray, n);
    }
}

