/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import org.tinymediamanager.scraper.entities.MediaArtwork;

public enum MediaFileType {
    VIDEO,
    TRAILER,
    SAMPLE,
    VIDEO_EXTRA,
    AUDIO,
    SUBTITLE,
    NFO,
    POSTER,
    FANART,
    BANNER,
    CLEARART,
    DISC,
    LOGO,
    CLEARLOGO,
    THUMB,
    CHARACTERART,
    KEYART,
    SEASON_POSTER,
    SEASON_FANART,
    SEASON_BANNER,
    SEASON_THUMB,
    EXTRAFANART,
    EXTRATHUMB,
    EXTRA,
    GRAPHIC,
    MEDIAINFO,
    VSMETA,
    THEME,
    TEXT,
    DOUBLE_EXT,
    UNKNOWN;


    public static MediaFileType getMediaFileType(MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case BACKGROUND: {
                return FANART;
            }
            case BANNER: {
                return BANNER;
            }
            case POSTER: {
                return POSTER;
            }
            case SEASON_POSTER: {
                return SEASON_POSTER;
            }
            case SEASON_FANART: {
                return SEASON_FANART;
            }
            case SEASON_BANNER: {
                return SEASON_BANNER;
            }
            case SEASON_THUMB: {
                return SEASON_THUMB;
            }
            case THUMB: {
                return THUMB;
            }
            case CLEARART: {
                return CLEARART;
            }
            case CLEARLOGO: 
            case LOGO: {
                return CLEARLOGO;
            }
            case CHARACTERART: {
                return CHARACTERART;
            }
            case DISC: {
                return DISC;
            }
            case KEYART: {
                return KEYART;
            }
        }
        return GRAPHIC;
    }

    public static MediaArtwork.MediaArtworkType getMediaArtworkType(MediaFileType fileType) {
        switch (fileType) {
            case FANART: {
                return MediaArtwork.MediaArtworkType.BACKGROUND;
            }
            case BANNER: {
                return MediaArtwork.MediaArtworkType.BANNER;
            }
            case POSTER: {
                return MediaArtwork.MediaArtworkType.POSTER;
            }
            case SEASON_POSTER: {
                return MediaArtwork.MediaArtworkType.SEASON_POSTER;
            }
            case SEASON_FANART: {
                return MediaArtwork.MediaArtworkType.SEASON_FANART;
            }
            case SEASON_BANNER: {
                return MediaArtwork.MediaArtworkType.SEASON_BANNER;
            }
            case SEASON_THUMB: {
                return MediaArtwork.MediaArtworkType.SEASON_THUMB;
            }
            case THUMB: {
                return MediaArtwork.MediaArtworkType.THUMB;
            }
            case CLEARART: {
                return MediaArtwork.MediaArtworkType.CLEARART;
            }
            case CLEARLOGO: 
            case LOGO: {
                return MediaArtwork.MediaArtworkType.CLEARLOGO;
            }
            case CHARACTERART: {
                return MediaArtwork.MediaArtworkType.CHARACTERART;
            }
            case DISC: {
                return MediaArtwork.MediaArtworkType.DISC;
            }
            case KEYART: {
                return MediaArtwork.MediaArtworkType.KEYART;
            }
        }
        throw new IllegalStateException();
    }

    public static MediaFileType[] getGraphicMediaFileTypes() {
        return new MediaFileType[]{FANART, POSTER, BANNER, CLEARART, DISC, LOGO, CLEARLOGO, THUMB, CHARACTERART, KEYART, SEASON_POSTER, SEASON_FANART, SEASON_BANNER, SEASON_THUMB, EXTRAFANART, EXTRATHUMB};
    }
}

