/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.iso9660.EntryInputStream;
import com.github.stephenc.javaisotools.loopfs.iso9660.EntryIterator;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660VolumeDescriptorSet;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspFieldSP;
import com.github.stephenc.javaisotools.loopfs.spi.AbstractBlockFileSystem;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInput;
import com.github.stephenc.javaisotools.loopfs.spi.SeekableInputFile;
import com.github.stephenc.javaisotools.loopfs.spi.VolumeDescriptorSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

public class Iso9660FileSystem
extends AbstractBlockFileSystem<Iso9660FileEntry> {
    private boolean enableSUSPScan;
    private Boolean suspUsedCache = null;

    public Iso9660FileSystem(File file, boolean bl) throws IOException {
        this((SeekableInput)new SeekableInputFile(file), bl, false);
    }

    public Iso9660FileSystem(File file, boolean bl, boolean bl2) throws IOException {
        this((SeekableInput)new SeekableInputFile(file), bl, bl2);
    }

    public Iso9660FileSystem(SeekableInput seekableInput, boolean bl) throws IOException {
        this(seekableInput, bl, false);
    }

    public Iso9660FileSystem(SeekableInput seekableInput, boolean bl, boolean bl2) throws IOException {
        super(seekableInput, bl, 2048, 16);
        this.enableSUSPScan = bl2;
    }

    public String getEncoding() {
        return ((Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet()).getEncoding();
    }

    public InputStream getInputStream(Iso9660FileEntry iso9660FileEntry) {
        this.ensureOpen();
        return new EntryInputStream(iso9660FileEntry, this);
    }

    byte[] getBytes(Iso9660FileEntry iso9660FileEntry) throws IOException {
        int n = (int)iso9660FileEntry.getSize();
        byte[] byArray = new byte[n];
        this.readBytes(iso9660FileEntry, 0L, byArray, 0, n);
        return byArray;
    }

    public int readBytes(Iso9660FileEntry iso9660FileEntry, long l, byte[] byArray, int n, int n2) throws IOException {
        long l2 = iso9660FileEntry.getStartBlock() * 2048L + l;
        return this.readData(l2, byArray, n, n2);
    }

    protected Iterator<Iso9660FileEntry> iterator(Iso9660FileEntry iso9660FileEntry) {
        Iso9660VolumeDescriptorSet iso9660VolumeDescriptorSet = (Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet();
        Iso9660FileEntry iso9660FileEntry2 = iso9660VolumeDescriptorSet.getPrimaryRootEntry();
        if (this.suspUsed().booleanValue()) {
            return new EntryIterator(this, iso9660FileEntry2);
        }
        if (iso9660VolumeDescriptorSet.hasSupplementary()) {
            Iso9660FileEntry iso9660FileEntry3 = iso9660VolumeDescriptorSet.getSupRootEntry();
            return new EntryIterator(this, iso9660FileEntry3);
        }
        return new EntryIterator(this, iso9660FileEntry2);
    }

    public Iso9660VolumeDescriptorSet getIso9660DescriptorSet() {
        if (null == this.volumeDescriptorSet) {
            try {
                this.loadVolumeDescriptors();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return (Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet();
    }

    protected VolumeDescriptorSet<Iso9660FileEntry> createVolumeDescriptorSet() {
        return new Iso9660VolumeDescriptorSet(this);
    }

    private boolean suspEnabled() {
        Iso9660VolumeDescriptorSet iso9660VolumeDescriptorSet = (Iso9660VolumeDescriptorSet)this.getVolumeDescriptorSet();
        Iso9660FileEntry iso9660FileEntry = iso9660VolumeDescriptorSet.getPrimaryRootEntry();
        if (iso9660FileEntry == null) {
            throw new RuntimeException("Root entry has not been loaded yet");
        }
        List<SuspField> list = iso9660FileEntry.getSuspFields();
        if (list.toArray().length < 1) {
            return false;
        }
        SuspField suspField = list.get(0);
        if (suspField.getId() != 21328) {
            return false;
        }
        SuspFieldSP suspFieldSP = (SuspFieldSP)suspField;
        return suspFieldSP.suspEnabled();
    }

    public Boolean suspUsed() {
        if (!this.enableSUSPScan) {
            return false;
        }
        if (this.suspUsedCache != null) {
            return this.suspUsedCache;
        }
        this.suspUsedCache = this.suspEnabled();
        return this.suspUsedCache;
    }
}

