/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mp4parser.Container;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.EditListBox;
import org.mp4parser.boxes.iso14496.part12.MediaHeaderBox;
import org.mp4parser.boxes.iso14496.part12.MovieExtendsBox;
import org.mp4parser.boxes.iso14496.part12.MovieFragmentBox;
import org.mp4parser.boxes.iso14496.part12.MovieHeaderBox;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part12.SampleDescriptionBox;
import org.mp4parser.boxes.iso14496.part12.SampleFlags;
import org.mp4parser.boxes.iso14496.part12.SampleTableBox;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.iso14496.part12.TimeToSampleBox;
import org.mp4parser.boxes.iso14496.part12.TrackBox;
import org.mp4parser.boxes.iso14496.part12.TrackExtendsBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentBox;
import org.mp4parser.boxes.iso14496.part12.TrackFragmentHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TrackHeaderBox;
import org.mp4parser.boxes.iso14496.part12.TrackRunBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.boxes.samplegrouping.SampleGroupDescriptionBox;
import org.mp4parser.boxes.samplegrouping.SampleToGroupBox;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Edit;
import org.mp4parser.muxer.RandomAccessSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.muxer.container.mp4.Mp4SampleList;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.Mp4Arrays;
import org.mp4parser.tools.Path;

public class Mp4TrackImpl
extends AbstractTrack {
    private List<Sample> samples;
    private SampleDescriptionBox sampleDescriptionBox;
    private long[] decodingTimes;
    private List<CompositionTimeToSample.Entry> compositionTimeEntries;
    private long[] syncSamples = null;
    private List<SampleDependencyTypeBox.Entry> sampleDependencies;
    private TrackMetaData trackMetaData = new TrackMetaData();
    private String handler;
    private SubSampleInformationBox subSampleInformationBox = null;

    public Mp4TrackImpl(long trackId, Container isofile, RandomAccessSource randomAccess, String name) {
        super(name);
        this.samples = new Mp4SampleList(trackId, isofile, randomAccess);
        TrackBox trackBox = null;
        for (TrackBox box : Path.getPaths((Container)isofile, (String)"moov/trak")) {
            if (box.getTrackHeaderBox().getTrackId() != trackId) continue;
            trackBox = box;
            break;
        }
        assert (trackBox != null) : "Could not find TrackBox with trackID " + trackId;
        SampleTableBox stbl = trackBox.getMediaBox().getMediaInformationBox().getSampleTableBox();
        this.handler = trackBox.getMediaBox().getHandlerBox().getHandlerType();
        ArrayList<TimeToSampleBox.Entry> decodingTimeEntries = new ArrayList<TimeToSampleBox.Entry>();
        this.compositionTimeEntries = new ArrayList<CompositionTimeToSample.Entry>();
        this.sampleDependencies = new ArrayList<SampleDependencyTypeBox.Entry>();
        decodingTimeEntries.addAll(stbl.getTimeToSampleBox().getEntries());
        if (stbl.getCompositionTimeToSample() != null) {
            this.compositionTimeEntries.addAll(stbl.getCompositionTimeToSample().getEntries());
        }
        if (stbl.getSampleDependencyTypeBox() != null) {
            this.sampleDependencies.addAll(stbl.getSampleDependencyTypeBox().getEntries());
        }
        if (stbl.getSyncSampleBox() != null) {
            this.syncSamples = stbl.getSyncSampleBox().getSampleNumber();
        }
        this.subSampleInformationBox = (SubSampleInformationBox)Path.getPath((AbstractContainerBox)stbl, (String)"subs");
        ArrayList movieFragmentBoxes = new ArrayList();
        movieFragmentBoxes.addAll(isofile.getBoxes(MovieFragmentBox.class));
        this.sampleDescriptionBox = stbl.getSampleDescriptionBox();
        int lastSubsSample = 0;
        List movieExtendsBoxes = Path.getPaths((Container)isofile, (String)"moov/mvex");
        if (movieExtendsBoxes.size() > 0) {
            for (MovieExtendsBox mvex : movieExtendsBoxes) {
                List trackExtendsBoxes = mvex.getBoxes(TrackExtendsBox.class);
                Iterator iterator = trackExtendsBoxes.iterator();
                while (iterator.hasNext()) {
                    TrackExtendsBox trex = (TrackExtendsBox)iterator.next();
                    if (trex.getTrackId() != trackId) continue;
                    List subss = Path.getPaths((Container)isofile, (String)"moof/traf/subs");
                    if (subss.size() > 0) {
                        this.subSampleInformationBox = new SubSampleInformationBox();
                    }
                    long sampleNumber = 1L;
                    for (MovieFragmentBox movieFragmentBox : movieFragmentBoxes) {
                        List trafs = movieFragmentBox.getBoxes(TrackFragmentBox.class);
                        for (TrackFragmentBox traf : trafs) {
                            if (traf.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
                            this.sampleGroups = this.getSampleGroups(stbl.getBoxes(SampleGroupDescriptionBox.class), Path.getPaths((Container)traf, (String)"sgpd"), Path.getPaths((Container)traf, (String)"sbgp"), this.sampleGroups, sampleNumber - 1L);
                            SubSampleInformationBox subs = (SubSampleInformationBox)Path.getPath((AbstractContainerBox)traf, (String)"subs");
                            if (subs != null) {
                                long difFromLastFragment = sampleNumber - (long)lastSubsSample - 1L;
                                for (SubSampleInformationBox.SubSampleEntry subSampleEntry : subs.getEntries()) {
                                    SubSampleInformationBox.SubSampleEntry se = new SubSampleInformationBox.SubSampleEntry();
                                    se.getSubsampleEntries().addAll(subSampleEntry.getSubsampleEntries());
                                    if (difFromLastFragment != 0L) {
                                        se.setSampleDelta(difFromLastFragment + subSampleEntry.getSampleDelta());
                                        difFromLastFragment = 0L;
                                    } else {
                                        se.setSampleDelta(subSampleEntry.getSampleDelta());
                                    }
                                    this.subSampleInformationBox.getEntries().add(se);
                                }
                            }
                            List truns = traf.getBoxes(TrackRunBox.class);
                            for (TrackRunBox trun : truns) {
                                TrackFragmentHeaderBox tfhd = traf.getTrackFragmentHeaderBox();
                                boolean first = true;
                                for (TrackRunBox.Entry entry : trun.getEntries()) {
                                    SampleFlags sampleFlags;
                                    TimeToSampleBox.Entry e;
                                    if (trun.isSampleDurationPresent()) {
                                        if (decodingTimeEntries.size() == 0 || ((TimeToSampleBox.Entry)decodingTimeEntries.get(decodingTimeEntries.size() - 1)).getDelta() != entry.getSampleDuration()) {
                                            decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, entry.getSampleDuration()));
                                        } else {
                                            e = (TimeToSampleBox.Entry)decodingTimeEntries.get(decodingTimeEntries.size() - 1);
                                            e.setCount(e.getCount() + 1L);
                                        }
                                    } else if (tfhd.hasDefaultSampleDuration()) {
                                        decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, tfhd.getDefaultSampleDuration()));
                                    } else {
                                        decodingTimeEntries.add(new TimeToSampleBox.Entry(1L, trex.getDefaultSampleDuration()));
                                    }
                                    if (trun.isSampleCompositionTimeOffsetPresent()) {
                                        if (this.compositionTimeEntries.size() == 0 || (long)this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1).getOffset() != entry.getSampleCompositionTimeOffset()) {
                                            this.compositionTimeEntries.add(new CompositionTimeToSample.Entry(1, CastUtils.l2i((long)entry.getSampleCompositionTimeOffset())));
                                        } else {
                                            e = this.compositionTimeEntries.get(this.compositionTimeEntries.size() - 1);
                                            e.setCount(e.getCount() + 1);
                                        }
                                    }
                                    if ((sampleFlags = trun.isSampleFlagsPresent() ? entry.getSampleFlags() : (first && trun.isFirstSampleFlagsPresent() ? trun.getFirstSampleFlags() : (tfhd.hasDefaultSampleFlags() ? tfhd.getDefaultSampleFlags() : trex.getDefaultSampleFlags()))) != null && !sampleFlags.isSampleIsDifferenceSample()) {
                                        this.syncSamples = Mp4Arrays.copyOfAndAppend((long[])this.syncSamples, (long[])new long[]{sampleNumber});
                                    }
                                    ++sampleNumber;
                                    first = false;
                                }
                            }
                        }
                    }
                }
            }
            for (MovieFragmentBox movieFragmentBox : movieFragmentBoxes) {
                for (TrackFragmentBox traf : movieFragmentBox.getBoxes(TrackFragmentBox.class)) {
                    if (traf.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
                    this.sampleGroups = this.getSampleGroups(stbl.getBoxes(SampleGroupDescriptionBox.class), Path.getPaths((Container)traf, (String)"sgpd"), Path.getPaths((Container)traf, (String)"sbgp"), this.sampleGroups, 0L);
                }
            }
        } else {
            this.sampleGroups = this.getSampleGroups(stbl.getBoxes(SampleGroupDescriptionBox.class), null, stbl.getBoxes(SampleToGroupBox.class), this.sampleGroups, 0L);
        }
        this.decodingTimes = TimeToSampleBox.blowupTimeToSamples(decodingTimeEntries);
        MediaHeaderBox mdhd = trackBox.getMediaBox().getMediaHeaderBox();
        TrackHeaderBox tkhd = trackBox.getTrackHeaderBox();
        this.trackMetaData.setTrackId(tkhd.getTrackId());
        this.trackMetaData.setCreationTime(mdhd.getCreationTime());
        this.trackMetaData.setLanguage(mdhd.getLanguage());
        this.trackMetaData.setModificationTime(mdhd.getModificationTime());
        this.trackMetaData.setTimescale(mdhd.getTimescale());
        this.trackMetaData.setHeight(tkhd.getHeight());
        this.trackMetaData.setWidth(tkhd.getWidth());
        this.trackMetaData.setLayer(tkhd.getLayer());
        this.trackMetaData.setMatrix(tkhd.getMatrix());
        this.trackMetaData.setVolume(tkhd.getVolume());
        EditListBox elst = (EditListBox)Path.getPath((AbstractContainerBox)trackBox, (String)"edts/elst");
        MovieHeaderBox mvhd = (MovieHeaderBox)Path.getPath((Container)isofile, (String)"moov/mvhd");
        if (elst != null) {
            assert (mvhd != null);
            for (EditListBox.Entry e : elst.getEntries()) {
                this.edits.add(new Edit(e.getMediaTime(), mdhd.getTimescale(), e.getMediaRate(), (double)e.getSegmentDuration() / (double)mvhd.getTimescale()));
            }
        }
    }

    private Map<GroupEntry, long[]> getSampleGroups(List<SampleGroupDescriptionBox> globalSgdbs, List<SampleGroupDescriptionBox> localSgdbs, List<SampleToGroupBox> sbgps, Map<GroupEntry, long[]> sampleGroups, long startIndex) {
        for (SampleToGroupBox sbgp : sbgps) {
            int sampleNum = 0;
            for (SampleToGroupBox.Entry entry : sbgp.getEntries()) {
                if (entry.getGroupDescriptionIndex() > 0) {
                    GroupEntry groupEntry = null;
                    if (entry.getGroupDescriptionIndex() > 65535) {
                        for (SampleGroupDescriptionBox localSgdb : localSgdbs) {
                            if (!localSgdb.getGroupingType().equals(sbgp.getGroupingType())) continue;
                            groupEntry = (GroupEntry)localSgdb.getGroupEntries().get(entry.getGroupDescriptionIndex() - 1 & 0xFFFF);
                        }
                    } else {
                        for (SampleGroupDescriptionBox globalSgdb : globalSgdbs) {
                            if (!globalSgdb.getGroupingType().equals(sbgp.getGroupingType())) continue;
                            groupEntry = (GroupEntry)globalSgdb.getGroupEntries().get(entry.getGroupDescriptionIndex() - 1);
                        }
                    }
                    assert (groupEntry != null);
                    long[] samples = sampleGroups.get(groupEntry);
                    if (samples == null) {
                        samples = new long[]{};
                    }
                    long[] nuSamples = new long[CastUtils.l2i((long)entry.getSampleCount()) + samples.length];
                    System.arraycopy(samples, 0, nuSamples, 0, samples.length);
                    int i = 0;
                    while ((long)i < entry.getSampleCount()) {
                        nuSamples[samples.length + i] = startIndex + (long)sampleNum + (long)i;
                        ++i;
                    }
                    sampleGroups.put(groupEntry, nuSamples);
                }
                sampleNum = (int)((long)sampleNum + entry.getSampleCount());
            }
        }
        return sampleGroups;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public synchronized long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return this.sampleDescriptionBox.getBoxes(SampleEntry.class);
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.compositionTimeEntries;
    }

    @Override
    public long[] getSyncSamples() {
        if (this.syncSamples == null || this.syncSamples.length == this.samples.size()) {
            return null;
        }
        return this.syncSamples;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sampleDependencies;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return this.handler;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.subSampleInformationBox;
    }
}

