/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatProgressBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class TmmProgressBarUI
extends FlatProgressBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new TmmProgressBarUI();
    }

    public void paint(Graphics g, JComponent c) {
        if (this.progressBar.isIndeterminate()) {
            this.paintIndeterminate(g, c);
        } else {
            this.paintDeterminate(g, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)g2D);
            Insets b = this.progressBar.getInsets();
            int w = this.progressBar.getWidth() - (b.right + b.left);
            int h = this.progressBar.getHeight() - (b.top + b.bottom);
            int amountFull = this.getAmountFull(b, w, h);
            if (this.progressBar.getOrientation() == 0) {
                int y = b.top + (h - this.horizontalSize.height) / 2;
                g2D.setColor(this.progressBar.getBackground());
                g2D.fillRoundRect(b.left, y, w, this.horizontalSize.height, this.arc, this.arc);
                g2D.setColor(this.progressBar.getForeground());
                g2D.fillRoundRect(b.left, y, amountFull, this.horizontalSize.height, this.arc, this.arc);
            } else {
                int x = b.left + (w - this.verticalSize.width) / 2;
                g2D.setColor(this.progressBar.getBackground());
                g2D.fillRoundRect(x, b.top, this.verticalSize.width, h, this.arc, this.arc);
                g2D.setColor(this.progressBar.getForeground());
                g2D.fillRoundRect(x, b.top, w, h - amountFull, this.arc, this.arc);
            }
        }
        finally {
            g2D.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)g2D);
            Insets b = this.progressBar.getInsets();
            int w = this.progressBar.getWidth() - (b.right + b.left);
            int h = this.progressBar.getHeight() - (b.top + b.bottom);
            if (this.progressBar.getOrientation() == 0) {
                int y = b.top + (h - this.horizontalSize.height) / 2;
                g2D.setColor(this.progressBar.getForeground());
                Area background = new Area(new RoundRectangle2D.Float(b.left, y, w, this.horizontalSize.height, this.arc, this.arc));
                g2D.fill(background);
                this.boxRect = this.getBox(this.boxRect);
                if (this.boxRect != null) {
                    w = UIScale.scale((int)20);
                    int x = this.getAnimationIndex();
                    GeneralPath p = new GeneralPath();
                    p.moveTo(this.boxRect.x, (float)this.boxRect.y + (float)this.boxRect.height);
                    p.lineTo((float)this.boxRect.x + (float)w * 0.5f, (float)this.boxRect.y + (float)this.boxRect.height);
                    p.lineTo((float)this.boxRect.x + (float)w, this.boxRect.y);
                    p.lineTo((float)this.boxRect.x + (float)w * 0.5f, this.boxRect.y);
                    p.closePath();
                    g2D.setColor(this.progressBar.getBackground());
                    for (int i = this.boxRect.width + x; i > -w; i -= w) {
                        Area bar = new Area(AffineTransform.getTranslateInstance(i, 0.0).createTransformedShape(p));
                        bar.intersect(background);
                        g2D.fill(bar);
                    }
                }
            } else {
                int x = b.left + (w - this.verticalSize.width) / 2;
                g2D.setColor(this.progressBar.getForeground());
                g2D.fillRoundRect(x, b.top, this.verticalSize.width, h, this.arc, this.arc);
            }
        }
        finally {
            g2D.dispose();
        }
    }

    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }
}

