/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieExporter;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.ExportTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.panels.ExporterPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;

public class MovieSetExportMovieAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetExportMovieAction.class);

    public MovieSetExportMovieAction() {
        this.putValue("SwingLargeIconKey", IconManager.EXPORT);
        this.putValue("SmallIcon", IconManager.EXPORT);
        this.putValue("Name", TmmResourceBundle.getString("movie.export"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final ArrayList<Movie> movies = new ArrayList<Movie>(MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovies(true));
        if (movies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        ModalPopupPanel popupPanel = MainWindow.getInstance().createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("movie.export"));
        ExporterPanel exporterPanel = new ExporterPanel(MediaEntityExporter.TemplateType.MOVIE){

            @Override
            protected void onClose() {
                Path exportPath;
                if (StringUtils.isBlank((CharSequence)this.tfExportDir.getText())) {
                    return;
                }
                ExportTemplate template = (ExportTemplate)this.list.getSelectedValue();
                if (template == null) {
                    return;
                }
                try {
                    exportPath = this.getExportPath();
                }
                catch (Exception e) {
                    LOGGER.debug("Aborted export - '{}'", (Object)e.getMessage());
                    return;
                }
                try {
                    TmmProperties.getInstance().putProperty(this.panelId + ".template", template.getName());
                    MovieExporter exporter = new MovieExporter(Paths.get(template.getPath(), new String[0]));
                    TmmTaskManager.getInstance().addMainTask(new ExportTask(TmmResourceBundle.getString("movie.export"), exporter, movies, exportPath));
                }
                catch (Exception e) {
                    LOGGER.error("Error exporting movie sets - '{}'", (Object)e.getMessage());
                }
                this.setVisible(false);
            }
        };
        popupPanel.setContent(exporterPanel);
        MainWindow.getInstance().showModalPopupPanel(popupPanel);
    }
}

