/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieLockedFilter
extends AbstractMovieUIFilter {
    private JComboBox<LockedFlag> combobox;

    @Override
    public boolean accept(Movie movie) {
        return !(movie.isLocked() ^ this.combobox.getSelectedItem() == LockedFlag.LOCKED);
    }

    @Override
    public String getId() {
        return "movieLocked";
    }

    @Override
    public String getFilterValueAsString() {
        try {
            return ((LockedFlag)((Object)this.combobox.getSelectedItem())).name();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setFilterValue(Object value) {
        LockedFlag lockedFlag;
        if (value == null) {
            return;
        }
        if (value instanceof LockedFlag) {
            this.combobox.setSelectedItem(value);
        } else if (value instanceof String && (lockedFlag = LockedFlag.valueOf((String)value)) != null) {
            this.combobox.setSelectedItem((Object)lockedFlag);
        }
    }

    @Override
    public void clearFilter() {
        this.combobox.setSelectedItem((Object)this.combobox.getItemAt(0));
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.locked"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.combobox = new JComboBox<LockedFlag>(LockedFlag.values());
        return this.combobox;
    }

    private static enum LockedFlag {
        LOCKED(TmmResourceBundle.getString("metatag.locked")),
        UNLOCKED(TmmResourceBundle.getString("metatag.unlocked"));

        private final String title;

        private LockedFlag(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

