/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.thirdparty.ImageLoader;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.components.label.LinkLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.thirdparty.imageviewer.ImageViewer;

public class ImagePreviewDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagePreviewDialog.class);
    private final JPanel imagePanel = new JPanel();
    private final ImageViewer imgViewer = new ImageViewer();
    private String imageUrl;
    private String imagePath;
    private String openFolderPath;
    private byte[] originalImageBytes;

    public ImagePreviewDialog(String urlToImage) {
        super(TmmResourceBundle.getString("image.show"), "imagePreview");
        this.init();
        this.imageUrl = urlToImage;
    }

    public ImagePreviewDialog(Path pathToImage) {
        super(TmmResourceBundle.getString("image.show"), "imagePreview");
        this.init();
        this.imagePath = pathToImage.toString();
    }

    public void setOpenFolderPath(String openFolderPath) {
        this.openFolderPath = openFolderPath;
    }

    private void init() {
        this.imgViewer.getPopupMenu().addSeparator();
        this.imgViewer.getPopupMenu().add(new SaveToDiskAction());
        this.imagePanel.setLayout((LayoutManager)new MigLayout("", "[300lp,grow]", "[300lp,grow][]"));
        this.getContentPane().add(this.imagePanel);
        JButton closeButton = new JButton(TmmResourceBundle.getString("Button.close"));
        closeButton.addActionListener(e -> this.setVisible(false));
        this.addDefaultButton(closeButton);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width = gd.getDisplayMode().getWidth();
            int height = gd.getDisplayMode().getHeight();
            this.setMaximumSize(new Dimension(width, height));
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    if (StringUtils.isNotBlank((CharSequence)ImagePreviewDialog.this.imagePath)) {
                        Path file = Paths.get(ImagePreviewDialog.this.imagePath, new String[0]);
                        ImagePreviewDialog.this.originalImageBytes = Files.readAllBytes(file);
                    } else if (StringUtils.isNotBlank((CharSequence)ImagePreviewDialog.this.imageUrl)) {
                        try {
                            Url url = new Url(ImagePreviewDialog.this.imageUrl);
                            ImagePreviewDialog.this.originalImageBytes = url.getBytesWithRetry(5);
                        }
                        catch (Exception e) {
                            LOGGER.error("Could not load image '{}' - '{}'", (Object)ImagePreviewDialog.this.imageUrl, (Object)e.getMessage());
                        }
                    }
                    if (ImagePreviewDialog.this.originalImageBytes.length > 0) {
                        try {
                            ImagePreviewDialog.this.imgViewer.setImage(ImageLoader.createImage(ImagePreviewDialog.this.originalImageBytes));
                            ImagePreviewDialog.this.imagePanel.removeAll();
                            ImagePreviewDialog.this.imagePanel.add((Component)ImagePreviewDialog.this.imgViewer.getComponent(), "cell 0 0, center, grow");
                            LinkLabel linkLabel = new LinkLabel(ImagePreviewDialog.this.imageUrl);
                            linkLabel.addActionListener(arg0 -> {
                                try {
                                    TmmUIHelper.browseUrl(ImagePreviewDialog.this.imageUrl);
                                }
                                catch (Exception e) {
                                    LOGGER.error("Could not open '{}' in browser - '{}'", (Object)ImagePreviewDialog.this.imageUrl, (Object)e.getMessage());
                                    MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)ImagePreviewDialog.this.imageUrl, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
                                }
                            });
                            ImagePreviewDialog.this.imagePanel.add((Component)linkLabel, "cell 0 1, center, wmin 0");
                            ImagePreviewDialog.this.imagePanel.revalidate();
                            ImagePreviewDialog.this.imagePanel.repaint();
                            if (ImagePreviewDialog.this.imgViewer.getImage().getWidth() > 0 && ImagePreviewDialog.this.imgViewer.getImage().getHeight() > 0) {
                                ImagePreviewDialog.this.setTitle(TmmResourceBundle.getString("image.show") + " - " + ImagePreviewDialog.this.imgViewer.getImage().getWidth() + "x" + ImagePreviewDialog.this.imgViewer.getImage().getHeight());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Could not load image '{}' - '{}'", (Object)ImagePreviewDialog.this.imageUrl, (Object)e.getMessage());
                        }
                    }
                    return null;
                }
            };
            worker.execute();
            this.pack();
            this.setLocationRelativeTo(MainWindow.getInstance());
            super.setVisible(true);
        } else {
            super.setVisible(false);
            this.dispose();
        }
    }

    private class SaveToDiskAction
    extends TmmAction {
        private SaveToDiskAction() {
            this.putValue("SwingLargeIconKey", IconManager.EXPORT);
            this.putValue("SmallIcon", IconManager.EXPORT);
            this.putValue("Name", TmmResourceBundle.getString("image.savetodisk"));
        }

        @Override
        protected void processAction(ActionEvent e) {
            SwingUtilities.invokeLater(() -> {
                block10: {
                    try {
                        String filename = "";
                        if (StringUtils.isNotBlank((CharSequence)ImagePreviewDialog.this.imagePath)) {
                            filename = FilenameUtils.getBaseName((String)ImagePreviewDialog.this.imagePath);
                        } else if (StringUtils.isNotBlank((CharSequence)ImagePreviewDialog.this.imageUrl)) {
                            filename = FilenameUtils.getBaseName((String)ImagePreviewDialog.this.imageUrl);
                        }
                        String initialPath = ImagePreviewDialog.this.openFolderPath != null ? ImagePreviewDialog.this.openFolderPath : "";
                        Path file = TmmUIHelper.saveFile(TmmResourceBundle.getString("image.savetodisk"), initialPath, filename, new FileNameExtensionFilter("Image files", ".jpg", ".png", ".webp"));
                        if (file == null) break block10;
                        try (FileOutputStream os = new FileOutputStream(file.toFile());){
                            IOUtils.write((byte[])ImagePreviewDialog.this.originalImageBytes, (OutputStream)os);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Could not save image file: {}", (Object)ex.getMessage());
                        MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"", "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
                    }
                }
            });
        }
    }
}

