/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.universal_movie;

import com.google.gson.Gson;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.config.MediaProviderConfig;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieTmdbMetadataProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class UniversalMovieMetadataProvider
implements IMovieMetadataProvider {
    public static final String ID = "universal_movie";
    private static final String UNDEFINED = "-";
    private static final String SEARCH = "search";
    private static final String RATINGS = "ratings";
    private static final String FALLBACK_SCRAPERS = "fallbackScrapers";
    private static final Logger LOGGER = LoggerFactory.getLogger(UniversalMovieMetadataProvider.class);
    private static final Map<String, IMovieMetadataProvider> COMPATIBLE_SCRAPERS = new LinkedHashMap<String, IMovieMetadataProvider>();
    private static final ExecutorService EXECUTOR = new ThreadPoolExecutor(4, 8, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    public UniversalMovieMetadataProvider() {
        this.init();
    }

    private MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, ID, "Universal movie scraper", "<html><h3>Universal movie scraper</h3><br />A meta scraper which allows to collect data from several other scrapers</html>", UniversalMovieMetadataProvider.class.getResource("/org/tinymediamanager/scraper/tmm_logo.svg"));
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled();
    }

    public static void addProvider(IMovieMetadataProvider provider) {
        if (!provider.getId().equals(ID) && !COMPATIBLE_SCRAPERS.containsKey(provider.getId()) && (provider instanceof IMovieTmdbMetadataProvider || provider instanceof IMovieImdbMetadataProvider)) {
            COMPATIBLE_SCRAPERS.put(provider.getId(), provider);
        }
    }

    private void init() {
        MediaProviderConfig config = this.providerInfo.getConfig();
        ArrayList<String> compatibleScraperIds = new ArrayList<String>(COMPATIBLE_SCRAPERS.keySet());
        compatibleScraperIds.add(0, UNDEFINED);
        config.addLabel("searchLabel", "Button.search");
        config.addSelect(SEARCH, SEARCH, compatibleScraperIds, UNDEFINED);
        config.addLabel("movieLabel", "tmm.metadata");
        config.addSelect("title", "metatag.title", compatibleScraperIds, UNDEFINED);
        config.addSelect("originalTitle", "metatag.originaltitle", compatibleScraperIds, UNDEFINED);
        config.addSelect("englishTitle", "metatag.title.english", Arrays.asList(UNDEFINED, "tmdb", "imdb"), UNDEFINED);
        config.addSelect("tagline", "metatag.tagline", compatibleScraperIds, UNDEFINED);
        config.addSelect("year", "metatag.year", compatibleScraperIds, UNDEFINED);
        config.addSelect("releaseDate", "metatag.releasedate", compatibleScraperIds, UNDEFINED);
        config.addSelect("plot", "metatag.plot", compatibleScraperIds, UNDEFINED);
        config.addSelect("runtime", "metatag.runtime", compatibleScraperIds, UNDEFINED);
        config.addSelect(RATINGS, "metatag.rating", this.scrapersWithout(compatibleScraperIds, "tvdb"), UNDEFINED);
        config.addSelect("top250", "metatag.top250", compatibleScraperIds.contains("imdb") ? Arrays.asList(UNDEFINED, "imdb") : Collections.singletonList(UNDEFINED), UNDEFINED);
        config.addSelect("genres", "metatag.genre", compatibleScraperIds, UNDEFINED);
        config.addSelect("certifications", "metatag.certification", compatibleScraperIds, UNDEFINED);
        config.addSelect("productionCompanies", "metatag.production", compatibleScraperIds, UNDEFINED);
        config.addSelect("castMembers", "metatag.cast", compatibleScraperIds, UNDEFINED);
        config.addSelect("spokenLanguages", "metatag.spokenlanguages", compatibleScraperIds, UNDEFINED);
        config.addSelect("countries", "metatag.country", compatibleScraperIds, UNDEFINED);
        config.addSelect("tags", "metatag.tags", compatibleScraperIds, UNDEFINED);
        config.addSelect("collectionName", "metatag.movieset", compatibleScraperIds.contains("tmdb") ? Arrays.asList(UNDEFINED, "tmdb") : Collections.singletonList(UNDEFINED), UNDEFINED);
        config.addLabel("fallbackLabel", "scraper.universal_movie.scraperstouse");
        config.addMultiSelect(FALLBACK_SCRAPERS, "scraper.universal_movie.scrapers", this.scrapersWithout(compatibleScraperIds, UNDEFINED), new String[0]);
        config.load();
    }

    private List<String> scrapersWithout(List<String> scrapers, String ... excludes) {
        ArrayList<String> newScrapers = new ArrayList<String>(scrapers);
        for (String scraperToExclude : excludes) {
            newScrapers.remove(scraperToExclude);
        }
        return newScrapers;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        IMovieMetadataProvider mp = COMPATIBLE_SCRAPERS.get(this.providerInfo.getConfig().getValue(SEARCH));
        if (mp == null) {
            return results;
        }
        try {
            for (MediaSearchResult result : mp.search(options)) {
                result.setId(this.providerInfo.getId(), result.getIdAsString(result.getProviderId()));
                result.setProviderId(this.providerInfo.getId());
                results.add(result);
            }
        }
        catch (ScrapeException e) {
            LOGGER.debug("Could not call search method of {} - {}", (Object)mp.getProviderInfo().getId(), (Object)e.getMessage());
            throw e;
        }
        return results;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata() - {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        MediaMetadata md = new MediaMetadata(this.providerInfo.getId());
        md.setScrapeOptions(options);
        Set<IMovieMetadataProvider> metadataProviders = this.getRelevantMetadataProviders();
        if (metadataProviders.isEmpty()) {
            return md;
        }
        Map<String, MediaMetadata> metadataMap = this.getMetadataMap(metadataProviders, options);
        this.assignResults(md, metadataMap);
        if (md.getIds().isEmpty()) {
            throw new NothingFoundException();
        }
        return md;
    }

    private Set<IMovieMetadataProvider> getRelevantMetadataProviders() {
        HashSet<IMovieMetadataProvider> metadataProviders = new HashSet<IMovieMetadataProvider>();
        for (Map.Entry<String, String> entry : this.providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            List<String> values = FALLBACK_SCRAPERS.equals(entry.getKey()) ? Arrays.asList((String[])new Gson().fromJson(entry.getValue(), String[].class)) : Collections.singletonList(entry.getValue());
            for (String value : values) {
                IMovieMetadataProvider mp;
                if (UNDEFINED.equals(value) || (mp = COMPATIBLE_SCRAPERS.get(value)) == null || !mp.isActive()) continue;
                metadataProviders.add(mp);
            }
        }
        return metadataProviders;
    }

    private Map<String, MediaMetadata> getMetadataMap(Set<IMovieMetadataProvider> metadataProviders, MovieSearchAndScrapeOptions options) {
        String imdbId = options.getImdbId();
        int tmdbId = options.getTmdbId();
        HashMap<String, MediaMetadata> metadataMap = new HashMap<String, MediaMetadata>();
        for (IMovieMetadataProvider mp : metadataProviders) {
            Object object;
            if (mp instanceof IMovieImdbMetadataProvider && MediaIdUtil.isValidImdbId(imdbId) || mp instanceof IMovieTmdbMetadataProvider && tmdbId > 0 || tmdbId <= 0 && !MediaIdUtil.isValidImdbId(imdbId)) continue;
            MediaMetadata md = (MediaMetadata)metadataMap.get("tmdb");
            if (md == null) {
                try {
                    IMovieMetadataProvider iMovieMetadataProvider = COMPATIBLE_SCRAPERS.get("tmdb");
                    if (iMovieMetadataProvider != null && (md = iMovieMetadataProvider.getMetadata(options)) != null) {
                        metadataMap.put("tmdb", md);
                    }
                }
                catch (Exception exception) {
                    LOGGER.debug("Could not get a result from scraper: {}", (Object)exception.getMessage());
                }
            }
            if (md == null) continue;
            if (tmdbId == 0 && (object = md.getId("tmdb")) != null) {
                try {
                    tmdbId = object instanceof Integer ? (Integer)object : Integer.parseInt((String)md.getId("tmdb"));
                }
                catch (Exception ignored) {
                    LOGGER.trace("could not parse tmdb id: - {}", md.getId("tmdb"));
                }
            }
            if (MediaIdUtil.isValidImdbId(imdbId) || !MediaIdUtil.isValidImdbId((String)md.getId("imdb"))) continue;
            imdbId = (String)md.getId("imdb");
        }
        if (MediaIdUtil.isValidImdbId(imdbId)) {
            options.setImdbId(imdbId);
        }
        if (tmdbId > 0) {
            options.setTmdbId(tmdbId);
        }
        ExecutorCompletionService<MediaMetadata> completionService = new ExecutorCompletionService<MediaMetadata>(EXECUTOR);
        ArrayList<Future<MediaMetadata>> futures = new ArrayList<Future<MediaMetadata>>();
        for (IMovieMetadataProvider iMovieMetadataProvider : metadataProviders) {
            if (metadataMap.get(iMovieMetadataProvider.getProviderInfo().getId()) != null || !iMovieMetadataProvider.isActive()) continue;
            futures.add(completionService.submit(new MetadataProviderWorker(iMovieMetadataProvider, options)));
        }
        for (Future future : futures) {
            try {
                MediaMetadata mediaMetadata = (MediaMetadata)future.get();
                if (mediaMetadata == null) continue;
                metadataMap.put(mediaMetadata.getProviderId(), mediaMetadata);
            }
            catch (Exception e) {
                LOGGER.debug("Could not get a result from scraper: {}", (Object)e.getMessage());
            }
        }
        return metadataMap;
    }

    private void assignResults(MediaMetadata md, Map<String, MediaMetadata> metadataMap) {
        for (Map.Entry<String, MediaMetadata> entry : metadataMap.entrySet()) {
            for (Map.Entry<String, Object> id : entry.getValue().getIds().entrySet()) {
                md.setId(id.getKey(), id.getValue());
            }
        }
        List<String> fallbackScrapers = Arrays.asList((String[])new Gson().fromJson(this.providerInfo.getConfig().getValue(FALLBACK_SCRAPERS), String[].class));
        for (Map.Entry<String, String> entry : this.providerInfo.getConfig().getConfigKeyValuePairs().entrySet()) {
            if (SEARCH.equals(entry.getKey()) || FALLBACK_SCRAPERS.equals(entry.getKey()) || UNDEFINED.equals(entry.getValue())) continue;
            ArrayList<String> scrapers = new ArrayList<String>(fallbackScrapers);
            scrapers.remove(entry.getValue());
            scrapers.add(0, entry.getValue());
            this.assignValue(scrapers, md, metadataMap, entry.getKey());
        }
    }

    private void assignValue(List<String> scrapers, MediaMetadata md, Map<String, MediaMetadata> metadataMap, String field) {
        for (String scraper : scrapers) {
            MediaMetadata mediaMetadata = metadataMap.get(scraper);
            if (mediaMetadata == null) continue;
            try {
                Method getter = new PropertyDescriptor(field, MediaMetadata.class).getReadMethod();
                Method setter = new PropertyDescriptor(field, MediaMetadata.class).getWriteMethod();
                Object value = getter.invoke((Object)mediaMetadata, new Object[0]);
                if (!this.isValueFilled(value)) continue;
                setter.invoke((Object)md, value);
                return;
            }
            catch (Exception e) {
                LOGGER.debug("Problem assigning {} - {}", (Object)scraper, (Object)e.getMessage());
            }
        }
    }

    private boolean isValueFilled(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String string = (String)value;
            return StringUtils.isNotBlank((CharSequence)string);
        }
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i != 0;
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.floatValue() != 0.0f;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Date) {
            return true;
        }
        if (value instanceof MediaAiredStatus) {
            return value != MediaAiredStatus.UNKNOWN;
        }
        return false;
    }

    protected static class MetadataProviderWorker
    implements Callable<MediaMetadata> {
        private final IMovieMetadataProvider metadataProvider;
        private final MovieSearchAndScrapeOptions mediaScrapeOptions;

        MetadataProviderWorker(IMovieMetadataProvider metadataProvider, MovieSearchAndScrapeOptions mediaScrapeOptions) {
            this.metadataProvider = metadataProvider;
            this.mediaScrapeOptions = mediaScrapeOptions;
        }

        @Override
        public MediaMetadata call() throws Exception {
            return this.metadataProvider.getMetadata(this.mediaScrapeOptions);
        }
    }
}

