/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.movie.MoviePostProcessExecutor;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieSetMoviePostProcessExecutor
extends MoviePostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetMoviePostProcessExecutor.class);

    public MovieSetMoviePostProcessExecutor(PostProcess postProcess, List<Movie> movies) {
        super(postProcess, movies);
    }

    @Override
    public void execute() {
        for (MediaEntity entity : this.entities) {
            if (!(entity instanceof Movie)) continue;
            Movie movie = (Movie)entity;
            LOGGER.info("Executing post process '{}' for movie '{}'", (Object)this.postProcess.getName(), (Object)movie.getTitle());
            String[] command = this.substituteMovieTokens(movie);
            try {
                this.executeCommand(command, movie);
                LOGGER.info("Successfully executed post process '{}' for movie '{}'", (Object)this.postProcess.getName(), (Object)movie.getTitle());
            }
            catch (Exception exception) {}
        }
    }
}

