/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import org.mp4parser.Container;
import org.mp4parser.muxer.Movie;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.builder.FragmentedMp4Builder;
import org.mp4parser.muxer.container.mp4.MovieCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.thirdparty.FFmpeg;

public class TmmMuxer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmMuxer.class);
    private final Path audioFile;
    private final Path videoFile;

    public TmmMuxer(Path audio, Path video) {
        this.audioFile = audio;
        this.videoFile = video;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeAudioVideo(Path destination) throws IOException {
        Movie video = null;
        Movie audio = null;
        Movie movie = null;
        if (FFmpeg.isAvailable()) {
            try {
                FFmpeg.muxVideoAndAudio(this.videoFile, this.audioFile, destination);
                return;
            }
            catch (Exception e) {
                LOGGER.error("Could not mux files using FFmpeg - '{}'", (Object)e.getMessage());
            }
        }
        try {
            video = MovieCreator.build((String)this.videoFile.toAbsolutePath().toString());
            audio = MovieCreator.build((String)this.audioFile.toAbsolutePath().toString());
            movie = new Movie();
            movie.addTrack((Track)video.getTracks().get(0));
            movie.addTrack((Track)audio.getTracks().get(0));
            Container mp4file = new FragmentedMp4Builder().build(movie);
            try (FileChannel fc = new FileOutputStream(destination.toFile()).getChannel();){
                mp4file.writeContainer((WritableByteChannel)fc);
            }
            this.closeTracks(video);
            this.closeTracks(audio);
            this.closeTracks(movie);
        }
        catch (Throwable throwable) {
            this.closeTracks(video);
            this.closeTracks(audio);
            this.closeTracks(movie);
            throw throwable;
        }
    }

    private void closeTracks(Movie movie) {
        if (movie == null) {
            return;
        }
        for (Track track : movie.getTracks()) {
            try {
                track.close();
            }
            catch (Exception exception) {}
        }
    }
}

