/*
 * Decompiled with CFR 0.152.
 */
package com.hdcookbook.grin.util;

import com.hdcookbook.grin.util.Debug;
import com.hdcookbook.grin.util.Queue;

public class NetworkManager {
    static Object LOCK = new Object();
    private static int numActivations = 0;
    private static boolean destroyed = false;
    private static Queue queue = new Queue(10);
    private static Thread thread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Object object = LOCK;
        synchronized (object) {
            if (destroyed) {
                throw new IllegalStateException();
            }
            if (++numActivations > 1) {
                return;
            }
        }
        object = new Runnable(){

            @Override
            public void run() {
                try {
                    NetworkManager.processQueue();
                }
                catch (InterruptedException interruptedException) {
                    Debug.println("Network manager interrupted.");
                }
                Debug.println("Network manager thread exits.");
            }
        };
        thread = new Thread((Runnable)object, "Network Manager");
        thread.setPriority(3);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = LOCK;
        synchronized (object) {
            if (--numActivations < 1) {
                destroyed = true;
                LOCK.notifyAll();
            }
            if (thread != null) {
                thread.interrupt();
                thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enqueue(Runnable runnable) {
        Object object = LOCK;
        synchronized (object) {
            queue.add(runnable);
            LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processQueue() throws InterruptedException {
        while (true) {
            Runnable runnable;
            block9: {
                Object object = LOCK;
                synchronized (object) {
                    if (destroyed) {
                        return;
                    }
                    if (!queue.isEmpty()) {
                        runnable = (Runnable)queue.remove();
                        break block9;
                    }
                    LOCK.wait();
                    continue;
                }
            }
            try {
                Thread.currentThread();
                Thread.yield();
                runnable.run();
                continue;
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    throw (InterruptedException)throwable;
                }
                Debug.printStackTrace(throwable);
                continue;
            }
            break;
        }
    }
}

