/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660;

import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import java.io.IOException;
import java.io.InputStream;

class EntryInputStream
extends InputStream {
    private Iso9660FileEntry entry;
    private Iso9660FileSystem fileSystem;
    private long pos;
    private long rem;

    EntryInputStream(Iso9660FileEntry iso9660FileEntry, Iso9660FileSystem iso9660FileSystem) {
        this.fileSystem = iso9660FileSystem;
        this.entry = iso9660FileEntry;
        this.pos = 0L;
        this.rem = iso9660FileEntry.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.ensureOpen();
        if (this.rem <= 0L) {
            return -1;
        }
        if (n2 <= 0) {
            return 0;
        }
        int n4 = n2;
        if ((long)n4 > this.rem) {
            n4 = (int)this.rem;
        }
        Iso9660FileSystem iso9660FileSystem = this.fileSystem;
        synchronized (iso9660FileSystem) {
            if (this.fileSystem.isClosed()) {
                throw new IOException("ISO file closed.");
            }
            n3 = this.fileSystem.readBytes(this.entry, this.pos, byArray, n, n4);
        }
        if (n3 > 0) {
            this.pos += (long)n3;
            this.rem -= (long)n3;
        }
        return n3;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) == 1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public long skip(long l) {
        this.ensureOpen();
        long l2 = l > this.rem ? this.rem : l;
        this.pos += l2;
        this.rem -= l2;
        if (this.rem <= 0L) {
            this.close();
        }
        return l2;
    }

    @Override
    public int available() {
        if (this.rem > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (this.rem < 0L) {
            return 0;
        }
        return (int)this.rem;
    }

    public long size() {
        this.ensureOpen();
        return this.entry.getSize();
    }

    @Override
    public void close() {
        this.rem = 0L;
        this.entry = null;
        this.fileSystem = null;
    }

    private void ensureOpen() {
        if (null == this.entry) {
            throw new IllegalStateException("stream has been closed");
        }
    }
}

