/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.ScraperInTable;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

class TvShowImageSettingsPanel
extends JPanel {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private final List<ScraperInTable> artworkScrapers = new ArrayList<ScraperInTable>();
    private TmmTable tableScraper;
    private JTextPane tpScraperDescription;
    private JPanel panelScraperOptions;

    TvShowImageSettingsPanel() {
        List<String> enabledArtworkProviders = this.settings.getArtworkScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableArtworkScrapers()) {
            ScraperInTable artworkScraper = new ScraperInTable(scraper);
            if (enabledArtworkProviders.contains(artworkScraper.getScraperId())) {
                artworkScraper.setActive(true);
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.artworkScrapers.add(artworkScraper);
            ++counter;
        }
        this.initComponents();
        this.initDataBindings();
        Font font = UIManager.getFont("Label.font");
        Color color = UIManager.getColor("Label.foreground");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "); }";
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 10);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        this.tableScraper.getModel().addTableModelListener(arg0 -> {
            if (arg0.getColumn() == 0) {
                int row = arg0.getFirstRow();
                ScraperInTable changedScraper = this.artworkScrapers.get(row);
                if (changedScraper.getActive().booleanValue()) {
                    this.settings.addTvShowArtworkScraper(changedScraper.getScraperId());
                } else {
                    this.settings.removeTvShowArtworkScraper(changedScraper.getScraperId());
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(e -> {
            int index = this.tableScraper.convertRowIndexToModel(this.tableScraper.getSelectedRow());
            if (index > -1) {
                this.panelScraperOptions.removeAll();
                if (this.artworkScrapers.get(index).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                    this.panelScraperOptions.add(new MediaScraperConfigurationPanel(this.artworkScrapers.get(index).getMediaProvider()));
                }
                this.panelScraperOptions.revalidate();
            }
        });
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[grow]"));
        JPanel panelScraper = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][grow]", "[][shrink 0][grow,fill]"));
        TmmLabel lblScraperT = new TmmLabel(TmmResourceBundle.getString("scraper.artwork"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelScraper, lblScraperT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#artwork-scraper"));
        this.add((Component)collapsiblePanel, "cell 0 0,wmin 0,grow");
        this.tableScraper = new TmmTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                ScraperInTable scraper = TvShowImageSettingsPanel.this.artworkScrapers.get(row);
                comp.setEnabled(scraper.isEnabled());
                return comp;
            }
        };
        this.tableScraper.setRowHeight(29);
        this.tableScraper.setShowGrid(true);
        panelScraper.add((Component)this.tableScraper, "cell 1 0,grow");
        JSeparator separator = new JSeparator();
        panelScraper.add((Component)separator, "cell 1 1,growx");
        ScrollablePanel panelScraperDetails = new ScrollablePanel();
        panelScraper.add((Component)panelScraperDetails, "cell 1 2,grow");
        panelScraperDetails.setLayout((LayoutManager)new MigLayout("insets 0", "[400lp,grow]", "[][grow]"));
        this.tpScraperDescription = new ReadOnlyTextPane();
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        panelScraperDetails.add((Component)this.tpScraperDescription, "cell 0 0,grow");
        this.panelScraperOptions = new JPanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "cell 0 1, growx, wmin 0");
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.artworkScrapers, (JTable)this.tableScraper);
        BeanProperty artworkScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty).setColumnName("Aktiv").setColumnClass(Boolean.class);
        BeanProperty artworkScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty_1).setColumnName("Logo").setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty artworkScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding_1.addColumnBinding((Property)artworkScraperBeanProperty_2).setColumnName("Name").setEditable(false).setColumnClass(String.class);
        jTableBinding_1.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty_1);
        autoBinding_1.bind();
    }
}

