/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatTextAreaUI;
import com.formdev.flatlaf.ui.FlatTextBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;

public class TmmRoundTextAreaUI
extends FlatTextAreaUI {
    private FocusListener focusListener;
    private DocumentListener documentListener;

    public static ComponentUI createUI(JComponent c) {
        return new TmmRoundTextAreaUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.getComponent(), "opaque", false);
        this.getComponent().setBorder((Border)new FlatTextBorder());
    }

    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FlatUIUtils.RepaintFocusListener((Component)this.getComponent(), null);
        this.getComponent().addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        if (this.documentListener != null) {
            this.getComponent().getDocument().removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
    }

    protected void paintSafely(Graphics g) {
        TmmRoundTextAreaUI.paintBackground(g, this.getComponent(), this.focusedBackground);
        super.paintSafely(g);
    }

    protected void paintBackground(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintBackground(Graphics g, JTextComponent c, Color focusedBackground) {
        if (!c.isOpaque() && FlatUIUtils.getOutsideFlatBorder((JComponent)c) == null && FlatUIUtils.hasOpaqueBeenExplicitlySet((JComponent)c)) {
            return;
        }
        float focusWidth = FlatUIUtils.getBorderFocusWidth((JComponent)c);
        float arc = FlatUIUtils.getBorderArc((JComponent)c);
        if (c.isOpaque() && (focusWidth > 0.0f || arc > 0.0f)) {
            FlatUIUtils.paintParentBackground((Graphics)g, (JComponent)c);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)g2);
            g2.setColor(TmmRoundTextAreaUI.getBackground(c, focusedBackground));
            FlatUIUtils.paintComponentBackground((Graphics2D)g2, (int)0, (int)0, (int)c.getWidth(), (int)c.getHeight(), (float)focusWidth, (float)arc);
        }
        finally {
            g2.dispose();
        }
    }

    private static Color getBackground(JTextComponent c, Color focusedBackground) {
        Color background = c.getBackground();
        if (!(background instanceof UIResource)) {
            return background;
        }
        if (focusedBackground != null && FlatUIUtils.isPermanentFocusOwner((Component)c)) {
            return focusedBackground;
        }
        return background;
    }
}

