/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.tinymediamanager.scraper.tmdb.TmdbController;

public class TmdbInterceptor
implements Interceptor {
    private final TmdbController tmdbController;

    public TmdbInterceptor(TmdbController tmdbController) {
        this.tmdbController = tmdbController;
    }

    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        return TmdbInterceptor.handleIntercept(chain, this.tmdbController);
    }

    public static Response handleIntercept(Interceptor.Chain chain, TmdbController tmdbController) throws IOException {
        Request request = chain.request();
        if (!"api.themoviedb.org".equals(request.url().host()) && !"api.tmdb.org".equals(request.url().host())) {
            return chain.proceed(request);
        }
        HttpUrl.Builder urlBuilder = request.url().newBuilder();
        urlBuilder.setEncodedQueryParameter("api_key", tmdbController.apiKey());
        Request.Builder builder = request.newBuilder();
        builder.url(urlBuilder.build());
        Response response = chain.proceed(builder.build());
        return response;
    }
}

