/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thesportsdb;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.thesportsdb.TheSportsDbHelper;
import org.tinymediamanager.scraper.thesportsdb.TheSportsDbMetadataProvider;
import org.tinymediamanager.scraper.thesportsdb.entities.Event;
import org.tinymediamanager.scraper.thesportsdb.entities.Events;
import org.tinymediamanager.scraper.thesportsdb.entities.LeagueDetail;
import org.tinymediamanager.scraper.thesportsdb.entities.Leagues;
import org.tinymediamanager.scraper.thesportsdb.entities.Lineup;
import org.tinymediamanager.scraper.thesportsdb.entities.Lineups;
import org.tinymediamanager.scraper.thesportsdb.entities.Season;
import org.tinymediamanager.scraper.thesportsdb.entities.Seasons;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

public class TheSportsDbTvShowMetadataProvider
extends TheSportsDbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheSportsDbTvShowMetadataProvider.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(60L, 10L);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Leagues leagues;
        Response httpResponse;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        md.addEpisodeGroup(MediaEpisodeGroup.DEFAULT_AIRED);
        String language = options.getLanguage().getLanguage().toUpperCase(Locale.ROOT);
        String leagueId = options.getIdAsString("tsdb");
        if (leagueId == null || leagueId.isEmpty()) {
            LOGGER.debug("no league id available");
            throw new MissingIdException(new String[]{"tsdb"});
        }
        LeagueDetail league = null;
        LOGGER.debug("========= BEGIN TheSportsDB Scraping");
        try {
            httpResponse = this.api.lookupServiceV1().lookupLeague(leagueId).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            leagues = (Leagues)httpResponse.body();
            league = leagues.leagues.get(0);
        }
        catch (IOException e) {
            LOGGER.trace("could not get Main TvShow information: {}", (Object)e.getMessage());
        }
        if (!leagueId.equals(league.idLeague) && this.api.getApiKey().equals("3")) {
            try {
                this.api.swapFreeKey();
                httpResponse = this.api.lookupServiceV1().lookupLeague(leagueId).execute();
                this.api.swapFreeKey();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                leagues = (Leagues)httpResponse.body();
                league = leagues.leagues.get(0);
            }
            catch (IOException e) {
                LOGGER.trace("could not get Main TvShow information: {}", (Object)e.getMessage());
            }
        }
        if (league == null) {
            throw new NothingFoundException();
        }
        if (!leagueId.equals(league.idLeague)) {
            md.setTitle(options.getSearchQuery());
            md.setId("tsdb", leagueId);
            return md;
        }
        md.setId("tsdb", league.idLeague);
        md.setTitle(league.strLeague);
        md.setYear(MetadataUtil.parseInt(league.intFormedYear, 0));
        try {
            md.setReleaseDate(DateUtils.parseDate(league.dateFirstEvent));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse releasedate: {}", (Object)e.getMessage());
        }
        String plot = league.getDescriptionForLanguage(language);
        if (StringUtils.isBlank((CharSequence)plot)) {
            plot = league.getDescriptionForLanguage("EN");
        }
        if (StringUtils.isNotBlank((CharSequence)plot)) {
            md.setPlot(plot);
        }
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.POSTER, league.strPoster));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.BACKGROUND, league.strFanart1));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.BACKGROUND, league.strFanart2));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.BACKGROUND, league.strFanart3));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.BACKGROUND, league.strFanart4));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.BANNER, league.strBanner));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.THUMB, league.strBadge));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.CLEARLOGO, league.strLogo));
        List<Season> seasons = null;
        try {
            List<Season> seasonsWithPosters;
            Response response = this.api.listServiceV1().getSeasons(leagueId).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.code(), response.message());
            }
            seasons = ((Seasons)response.body()).seasons;
            response = this.api.listServiceV1().getSeasonsWithPosters(leagueId).execute();
            if (response.isSuccessful() && (seasonsWithPosters = ((Seasons)response.body()).seasons) != null && !seasonsWithPosters.isEmpty()) {
                seasons = seasonsWithPosters;
            }
        }
        catch (Exception e) {
            LOGGER.trace("could not get Episode information: {}", (Object)e.getMessage());
        }
        for (Season season : seasons) {
            MediaArtwork ma;
            int year = MetadataUtil.parseInt(season.strSeason.replaceAll("\\-.*", ""), 0);
            if (year <= 0 || (ma = this.imagesToMA(MediaArtwork.MediaArtworkType.SEASON_POSTER, season.strPoster)) == null) continue;
            ma.setSeason(year);
            md.addMediaArt(ma);
        }
        return md;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        List<MediaMetadata> events;
        String query;
        LOGGER.debug("getMetadata() TvShowEpisode: {}", (Object)options);
        this.initAPI();
        String eventId = options.getIdAsString("tsdb");
        Date aired = null;
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            aired = options.getMetadata().getReleaseDate();
        }
        if ((query = options.getSearchQuery()).isEmpty() && options.getMetadata() != null) {
            query = options.getMetadata().getTitle();
        }
        if (!(events = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions())).isEmpty()) {
            int n;
            int n2;
            if (eventId != null) {
                for (MediaMetadata mediaMetadata : events) {
                    if (!mediaMetadata.getIdAsString("tsdb").equals(eventId)) continue;
                    LOGGER.trace("found match via ID");
                    this.injectPlayers(mediaMetadata);
                    return mediaMetadata;
                }
            }
            if (aired != null) {
                HashMap found = new HashMap();
                for (MediaMetadata event : events) {
                    if (!aired.equals(event.getReleaseDate())) continue;
                    float score = MetadataUtil.calculateScore(query, event.getTitle());
                    found.put(Float.valueOf(score), event);
                }
                if (found != null && found.size() > 0) {
                    MediaMetadata event;
                    ArrayList arrayList = new ArrayList(found.keySet());
                    Collections.sort(arrayList);
                    Collections.reverse(arrayList);
                    LOGGER.trace("found match via releaseDate");
                    event = (MediaMetadata)found.get(arrayList.get(0));
                    this.injectPlayers(event);
                    return event;
                }
            }
            if (options.getMetadata() != null && query.length() > 0) {
                for (MediaMetadata mediaMetadata : events) {
                    if (!query.equals(mediaMetadata.getTitle())) continue;
                    LOGGER.trace("found match via title");
                    this.injectPlayers(mediaMetadata);
                    return mediaMetadata;
                }
            }
            MediaEpisodeGroup episodeGroup = options.getEpisodeGroup();
            int n3 = -1;
            int episodeNr = -1;
            Iterator iterator = options.getIds().get("episodeNr");
            if (iterator instanceof List) {
                List episodeNumbers = (List)((Object)iterator);
                for (Object obj : episodeNumbers) {
                    MediaEpisodeNumber episodeNumber;
                    if (!(obj instanceof MediaEpisodeNumber) || !(episodeNumber = (MediaEpisodeNumber)obj).episodeGroup().equals(episodeGroup)) continue;
                    episodeNr = episodeNumber.episode();
                    n2 = episodeNumber.season();
                    break;
                }
            }
            if (n2 == -1 && episodeNr == -1) {
                n = options.getIdAsIntOrDefault("seasonNr", -1);
                episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
            }
            if (n < 0 || episodeNr < 0) {
                throw new NothingFoundException();
            }
            for (MediaMetadata event : events) {
                MediaEpisodeNumber num = event.getEpisodeNumber(episodeGroup);
                if (num.episode() != episodeNr || num.season() != n) continue;
                LOGGER.trace("found match via S/EE numbers");
                return event;
            }
        }
        LOGGER.trace("Could not match anything from episodeList - trying direct");
        if (eventId != null) {
            try {
                Response httpResponse = this.api.lookupServiceV1().lookupEvent(eventId).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                Events events2 = (Events)httpResponse.body();
                Event event = events2.events.get(0);
                MediaMetadata md = this.getMetadataFromEvent(options, event);
                return md;
            }
            catch (IOException e) {
                LOGGER.trace("could not get Main TvShow information: {}", (Object)e.getMessage());
            }
        }
        throw new NothingFoundException();
    }

    private void injectPlayers(MediaMetadata md) {
        block12: {
            try {
                Lineups body;
                Response httpResponse;
                if (md.getCastMembers().size() != 2) break block12;
                md.setCastMembers(null);
                List<Lineup> lineups = null;
                try {
                    httpResponse = this.api.lookupServiceV1().lookupLineupForEvent(md.getIdAsString("tsdb")).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    body = (Lineups)httpResponse.body();
                    lineups = body.lineup;
                }
                catch (IOException e) {
                    LOGGER.trace("could not get Main TvShow information: {}", (Object)e.getMessage());
                }
                if (lineups == null || lineups.isEmpty()) {
                    throw new NothingFoundException();
                }
                if (((Lineup)lineups.get((int)0)).idEvent != md.getIdAsString("tsdb") && this.api.getApiKey().equals("3")) {
                    try {
                        this.api.swapFreeKey();
                        httpResponse = this.api.lookupServiceV1().lookupLineupForEvent(md.getIdAsString("tsdb")).execute();
                        this.api.swapFreeKey();
                        if (!httpResponse.isSuccessful()) {
                            throw new HttpException(httpResponse.code(), httpResponse.message());
                        }
                        body = (Lineups)httpResponse.body();
                        lineups = body.lineup;
                    }
                    catch (IOException e) {
                        LOGGER.trace("could not get Main TvShow information: {}", (Object)e.getMessage());
                    }
                }
                for (Lineup lineup : lineups) {
                    Person p = new Person(Person.Type.ACTOR);
                    if (lineup.strHome.equalsIgnoreCase("No")) {
                        p = new Person(Person.Type.GUEST);
                    }
                    p.setName(lineup.strPlayer);
                    p.setRole(lineup.strTeam + " - " + lineup.strPosition);
                    p.setId("tsdb", lineup.idPlayer);
                    p.setThumbUrl(lineup.strThumb);
                    md.addCastMember(p);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not inject players into metadata: {}", (Object)e.getMessage());
            }
        }
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search(): {}", (Object)options);
        this.initAPI();
        TreeSet<MediaSearchResult> searchResults = new TreeSet<MediaSearchResult>();
        String leagueId = options.getIdAsString("tsdb");
        if (leagueId != null && !leagueId.isEmpty()) {
            MediaMetadata md = this.getMetadata(options);
            MediaSearchResult msr = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
            msr.mergeFrom(md);
            msr.setScore(1.0f);
            searchResults.add(msr);
            return searchResults;
        }
        TheSportsDbHelper.SPORT_LEAGUES.forEach((k, v) -> {
            MediaSearchResult msr = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
            msr.setTitle((String)k);
            msr.setId("tsdb", v.idLeague);
            msr.calculateScore(options);
            if (msr.getScore() >= 0.75f) {
                searchResults.add(msr);
            }
        });
        return searchResults;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList: {}", (Object)options);
        this.initAPI();
        String leagueId = options.getIdAsString("tsdb");
        if (leagueId == null || leagueId.isEmpty()) {
            LOGGER.debug("no league id available");
            throw new MissingIdException(new String[]{"tsdb"});
        }
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(leagueId + "_" + options.getLanguage().getLanguage());
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        ArrayList<Event> eventList = new ArrayList<Event>();
        List<Season> seasons = null;
        try {
            Response response = this.api.listServiceV1().getSeasons(leagueId).execute();
            if (!response.isSuccessful()) {
                throw new HttpException(response.code(), response.message());
            }
            seasons = ((Seasons)response.body()).seasons;
        }
        catch (Exception e) {
            LOGGER.trace("could not get Episode information: {}", (Object)e.getMessage());
        }
        if (seasons == null) {
            throw new NothingFoundException();
        }
        for (Season season : seasons) {
            try {
                Response response = this.api.ScheduleServiceV1().getEvents(leagueId, season.strSeason).execute();
                if (!response.isSuccessful()) {
                    throw new HttpException(response.code(), response.message());
                }
                Events events = (Events)response.body();
                if (events.events.size() == 15 && this.api.getApiKey().equals("123")) {
                    LOGGER.trace("League {} / Season {} did return 15 events. There could be more with a paid API key...", (Object)leagueId, (Object)season.strSeason);
                }
                if (events.events.size() == 100 && this.api.getApiKey().equals("3")) {
                    LOGGER.trace("League {} / Season {} did return 100 events. There could be more with a paid API key...", (Object)leagueId, (Object)season.strSeason);
                }
                eventList.addAll(events.events);
            }
            catch (Exception e) {
                LOGGER.trace("could not get Episode information: {}", (Object)e.getMessage());
            }
        }
        ArrayList<MediaMetadata> returnList = new ArrayList<MediaMetadata>();
        for (Event event : eventList) {
            MediaMetadata md = this.getMetadataFromEvent(options, event);
            returnList.add(md);
        }
        if (ListUtils.isNotEmpty(returnList)) {
            EPISODE_LIST_CACHE_MAP.put(leagueId + "_" + options.getLanguage().getLanguage(), returnList);
        }
        return returnList;
    }

    private MediaMetadata getMetadataFromEvent(MediaSearchAndScrapeOptions options, Event event) {
        Person p;
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        md.setId("tsdb", event.idEvent);
        md.setTitle(event.strEvent);
        md.setPlot(event.strDescriptionEN);
        int season = 0;
        int ep = 0;
        try {
            Date d = DateUtils.parseDate(event.dateEvent);
            md.setReleaseDate(d);
            LocalDate ld = DateUtils.toLocalD(d);
            md.setYear(ld.getYear());
            season = ld.getYear();
        }
        catch (ParseException d) {
            // empty catch block
        }
        ep = MetadataUtil.parseInt(event.intRound, 0);
        md.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, season, ep);
        if (event.strHomeTeam != null && !event.strHomeTeam.isEmpty()) {
            p = new Person(Person.Type.ACTOR);
            p.setName(event.strHomeTeam);
            p.setRole("Home Team");
            p.setThumbUrl(event.strHomeTeamBadge);
            md.addCastMember(p);
        }
        if (event.strAwayTeam != null && !event.strAwayTeam.isEmpty()) {
            p = new Person(Person.Type.GUEST);
            p.setName(event.strAwayTeam);
            p.setRole("Away Team");
            p.setThumbUrl(event.strAwayTeamBadge);
            md.addCastMember(p);
        }
        md.addCountry(event.strVenue);
        md.addCountry(event.strCity);
        md.addCountry(event.strCountry);
        if (event.strVideo != null && !event.strVideo.isEmpty()) {
            MediaTrailer mt = new MediaTrailer();
            mt.setProvider(TheSportsDbTvShowMetadataProvider.getProviderFromUrl(event.strVideo));
            mt.setUrl(event.strVideo);
            mt.setDate(md.getReleaseDate());
            mt.setScrapedBy("tsdb");
            mt.setName(DateUtils.toLocalD(md.getReleaseDate()).toString() + " - " + event.strEvent);
            md.addTrailer(mt);
        }
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.POSTER, event.strPoster));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.BACKGROUND, event.strFanart));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.THUMB, event.strThumb));
        md.addMediaArt(this.imagesToMA(MediaArtwork.MediaArtworkType.BANNER, event.strBanner));
        return md;
    }

    private static String getProviderFromUrl(String url) {
        String domain = "unknown";
        try {
            URI u = new URI(url);
            if (u.getHost().matches("^((25[0-5]|(2[0-4]|1\\d|[1-9]|)\\d)\\.?\\b){4}$")) {
                domain = u.getHost();
            } else {
                String[] parts = u.getHost().split("\\.");
                domain = parts[parts.length - 2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url.contains("youtu.be")) {
            domain = "youtube";
        }
        return domain;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getArtwork(): {}", (Object)options);
        this.initAPI();
        try {
            if (options.getMediaType() != MediaType.TV_SHOW && options.getMediaType() != MediaType.TV_EPISODE) {
                return Collections.emptyList();
            }
            if (options.getMediaType() == MediaType.TV_EPISODE) {
                TvShowEpisodeSearchAndScrapeOptions episodeSearchAndScrapeOptions = new TvShowEpisodeSearchAndScrapeOptions();
                episodeSearchAndScrapeOptions.setDataFromOtherOptions(options);
                if (options.getIds().get("tvShowIds") instanceof Map) {
                    Map tvShowIds = (Map)options.getIds().get("tvShowIds");
                    episodeSearchAndScrapeOptions.setTvShowIds(tvShowIds);
                }
                MediaMetadata md = this.getMetadata(episodeSearchAndScrapeOptions);
                return md.getMediaArt(options.getArtworkType());
            }
            TvShowSearchAndScrapeOptions op = new TvShowSearchAndScrapeOptions();
            op.setDataFromOtherOptions(options);
            return this.getMetadata(op).getMediaArt(options.getArtworkType());
        }
        catch (MissingIdException | NothingFoundException e) {
            return Collections.emptyList();
        }
        catch (ScrapeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }

    private MediaArtwork imagesToMA(MediaArtwork.MediaArtworkType type, String imageUrl) {
        MediaArtwork ma = null;
        try {
            if (imageUrl != null && !imageUrl.isEmpty()) {
                ma = new MediaArtwork("tsdb", type);
                ma.setOriginalUrl(imageUrl);
                ma.setPreviewUrl(imageUrl + "/small");
                switch (type) {
                    case POSTER: 
                    case SEASON_POSTER: {
                        ma.addImageSize(680, 1000, imageUrl, MediaArtwork.PosterSizes.getSizeOrder(680));
                        ma.addImageSize(340, 500, imageUrl + "/small", MediaArtwork.PosterSizes.getSizeOrder(340));
                        break;
                    }
                    case BACKGROUND: 
                    case THUMB: 
                    case SEASON_FANART: 
                    case SEASON_THUMB: {
                        ma.addImageSize(1280, 720, imageUrl, MediaArtwork.FanartSizes.getSizeOrder(1280));
                        ma.addImageSize(640, 360, imageUrl + "/small", MediaArtwork.FanartSizes.getSizeOrder(640));
                        break;
                    }
                    case BANNER: 
                    case SEASON_BANNER: {
                        ma.addImageSize(1000, 185, imageUrl, MediaArtwork.getSizeOrder(type, 1000));
                        ma.addImageSize(540, 100, imageUrl + "/small", MediaArtwork.getSizeOrder(type, 540));
                        break;
                    }
                    case CLEARLOGO: {
                        ma.addImageSize(800, 310, imageUrl, MediaArtwork.getSizeOrder(type, 800));
                        ma.addImageSize(400, 155, imageUrl + "/small", MediaArtwork.getSizeOrder(type, 400));
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return ma;
    }
}

