/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import org.tinymediamanager.scraper.ScraperType;

public enum MediaType {
    TV_SHOW,
    TV_EPISODE,
    MOVIE,
    MOVIE_SET,
    SUBTITLE;


    public static MediaType toMediaType(String id) {
        if (id == null) {
            return null;
        }
        if ("movie".equalsIgnoreCase(id) || "movies".equalsIgnoreCase(id)) {
            return MOVIE;
        }
        if ("movieSet".equalsIgnoreCase(id) || "set".equalsIgnoreCase(id) || "movie_set".equalsIgnoreCase(id)) {
            return MOVIE_SET;
        }
        if ("tv".equalsIgnoreCase(id) || "tvShow".equalsIgnoreCase(id) || "tv_show".equalsIgnoreCase(id)) {
            return TV_SHOW;
        }
        if ("episode".equalsIgnoreCase(id) || "tvEpisode".equalsIgnoreCase(id) || "tv_episode".equalsIgnoreCase(id)) {
            return TV_EPISODE;
        }
        return null;
    }

    public static ScraperType getScraperTypeForMediaType(MediaType mediaType) {
        switch (mediaType) {
            case MOVIE: {
                return ScraperType.MOVIE;
            }
            case MOVIE_SET: {
                return ScraperType.MOVIE_SET;
            }
            case TV_SHOW: 
            case TV_EPISODE: {
                return ScraperType.TV_SHOW;
            }
        }
        return null;
    }
}

