/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.CertificationStyle;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.NfoUtils;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.connector.ITvShowEpisodeConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowConnectors;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeNfoNaming;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.util.DateUtils;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TvShowEpisodeGenericXmlConnector
implements ITvShowEpisodeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodeGenericXmlConnector.class);
    protected static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    protected final List<TvShowEpisode> episodes;
    protected final TvShowSettings settings;
    protected Document document;
    protected Element root;

    protected TvShowEpisodeGenericXmlConnector(List<TvShowEpisode> episodes) {
        this.episodes = episodes;
        this.settings = TvShowModuleManager.getInstance().getSettings();
    }

    protected abstract void addOwnTags(TvShowEpisode var1, TvShowEpisodeNfoParser.Episode var2);

    @Override
    public void write(List<TvShowEpisodeNfoNaming> nfoNames) {
        if (this.episodes.isEmpty()) {
            return;
        }
        TvShowEpisode firstEpisode = this.episodes.get(0);
        TvShowEpisodeNfoParser parser = null;
        if (!this.settings.isWriteCleanNfo()) {
            for (MediaFile mf : firstEpisode.getMediaFiles(MediaFileType.NFO)) {
                try {
                    parser = TvShowEpisodeNfoParser.parseNfo(mf.getFileAsPath());
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (TvShowEpisodeNfoNaming nfoNaming : nfoNames) {
            String nfoFilename = firstEpisode.getNfoFilename(nfoNaming);
            if (StringUtils.isBlank((CharSequence)nfoFilename)) continue;
            try {
                boolean first = true;
                StringBuilder xmlString = new StringBuilder();
                for (TvShowEpisode episode : this.episodes) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    this.document = factory.newDocumentBuilder().newDocument();
                    this.document.setXmlStandalone(true);
                    if (first) {
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String dat = formatter.format((Object)new Date());
                        TvShowConnectors conn = this.settings.getTvShowConnector();
                        this.document.appendChild(this.document.createComment("created on " + (String)dat + " by tinyMediaManager " + Settings.getInstance().getVersion() + " for " + conn.name()));
                    }
                    this.root = this.document.createElement("episodedetails");
                    this.document.appendChild(this.root);
                    TvShowEpisodeNfoParser.Episode parserEpisode = null;
                    if (parser != null) {
                        for (TvShowEpisodeNfoParser.Episode ep : parser.episodes) {
                            if (ep.season != episode.getSeason() || ep.episode != episode.getEpisode()) continue;
                            parserEpisode = ep;
                            break;
                        }
                    }
                    this.addTitle(episode, parserEpisode);
                    this.addOriginalTitle(episode, parserEpisode);
                    this.addShowTitle(episode, parserEpisode);
                    this.addSeason(episode, parserEpisode);
                    this.addEpisode(episode, parserEpisode);
                    this.addDisplaySeason(episode, parserEpisode);
                    this.addDisplayEpisode(episode, parserEpisode);
                    this.addId(episode, parserEpisode);
                    this.addIds(episode, parserEpisode);
                    this.addRating(episode, parserEpisode);
                    this.addUserrating(episode, parserEpisode);
                    this.addVotes(episode, parserEpisode);
                    this.addPlot(episode, parserEpisode);
                    this.addRuntime(episode, parserEpisode);
                    this.addThumb(episode, parserEpisode);
                    this.addMpaa(episode, parserEpisode);
                    this.addPremiered(episode, parserEpisode);
                    this.addAired(episode, parserEpisode);
                    this.addWatched(episode, parserEpisode);
                    this.addPlaycount(episode, parserEpisode);
                    this.addLastplayed(episode, parserEpisode);
                    this.addStudios(episode, parserEpisode);
                    this.addTags(episode, parserEpisode);
                    this.addCredits(episode, parserEpisode);
                    this.addDirectors(episode, parserEpisode);
                    this.addActors(episode, parserEpisode);
                    this.addTrailer(episode, parserEpisode);
                    this.addDateAdded(episode, parserEpisode);
                    this.addLockdata(episode, parserEpisode);
                    this.addFileinfo(episode, parserEpisode);
                    this.addOwnTags(episode, parserEpisode);
                    this.addUnsupportedTags(episode, parserEpisode);
                    this.addTinyMediaManagerTags(episode, parserEpisode);
                    StringWriter out = new StringWriter();
                    Transformer transformer = NfoUtils.getTransformer();
                    if (!first) {
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                    }
                    transformer.transform(new DOMSource(this.document), new StreamResult(out));
                    xmlString.append(((Object)out).toString().replaceAll("(?<!\r)\n", "\r\n"));
                    first = false;
                }
                String xml = xmlString.toString();
                Path f = firstEpisode.getPathNIO().resolve(nfoFilename);
                boolean changed = true;
                try {
                    String xmlOld = Utils.readFileToString(f).replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
                    String xmlNew = xml.replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
                    if (xmlOld.equals(xmlNew)) {
                        changed = false;
                    }
                }
                catch (Exception xmlOld) {
                    // empty catch block
                }
                if (changed) {
                    Utils.writeStringToFile(f, xml);
                } else {
                    LOGGER.debug("NFO did not change - do not write it!");
                }
                MediaFile mf = new MediaFile(f);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                LOGGER.error("Could not write epsiode NFO file '{}' - '{}'", (Object)firstEpisode.getPathNIO().resolve(nfoFilename), (Object)e.getMessage());
                MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)firstEpisode, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (!newNfos.isEmpty()) {
            for (TvShowEpisode episode : this.episodes) {
                List<MediaFile> existingNfos = episode.getMediaFiles(MediaFileType.NFO);
                for (MediaFile nfo : existingNfos) {
                    if (!TvShowConnectors.isValidTvShowEpisodeNFO(nfo.getFileAsPath())) {
                        newNfos.add(nfo);
                        continue;
                    }
                    if (newNfos.contains(nfo)) continue;
                    try {
                        Utils.deleteFileWithBackup(nfo.getFileAsPath(), episode.getTvShow().getDataSource());
                    }
                    catch (Exception e) {
                        LOGGER.debug("Could not remove orphaned NFO - '{}'", (Object)e.getMessage());
                    }
                }
                episode.removeAllMediaFiles(MediaFileType.NFO);
                episode.addToMediaFiles(newNfos);
            }
        }
    }

    protected void addTitle(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element title = this.document.createElement("title");
        title.setTextContent(episode.getTitle());
        this.root.appendChild(title);
    }

    protected void addOriginalTitle(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element originaltitle = this.document.createElement("originaltitle");
        originaltitle.setTextContent(episode.getOriginalTitle());
        this.root.appendChild(originaltitle);
    }

    protected void addShowTitle(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element title = this.document.createElement("showtitle");
        title.setTextContent(episode.getTvShow().getTitle());
        this.root.appendChild(title);
    }

    protected void addSeason(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element season = this.document.createElement("season");
        season.setTextContent(Integer.toString(episode.getSeason()));
        this.root.appendChild(season);
    }

    protected void addEpisode(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element episode1 = this.document.createElement("episode");
        episode1.setTextContent(Integer.toString(episode.getEpisode()));
        this.root.appendChild(episode1);
    }

    protected void addDisplaySeason(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element displayseason = this.document.createElement("displayseason");
        if (episode.getDisplaySeason() >= 0 && episode.getDisplayEpisode() >= 0) {
            displayseason.setTextContent(Integer.toString(episode.getDisplaySeason()));
            this.root.appendChild(displayseason);
        }
    }

    protected void addDisplayEpisode(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element displayepisode = this.document.createElement("displayepisode");
        if (episode.getDisplaySeason() >= 0 && episode.getDisplayEpisode() >= 0) {
            displayepisode.setTextContent(Integer.toString(episode.getDisplayEpisode()));
            this.root.appendChild(displayepisode);
        }
    }

    protected void addId(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element uniqueid = this.document.createElement("id");
        uniqueid.setTextContent(episode.getTvdbId());
        this.root.appendChild(uniqueid);
    }

    protected void addIds(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        String defaultScraper = NfoUtils.detectDefaultScraper(episode);
        for (Map.Entry<String, Object> entry : episode.getIds().entrySet()) {
            Element uniqueid = this.document.createElement("uniqueid");
            uniqueid.setAttribute("type", entry.getKey());
            if (defaultScraper.equals(entry.getKey())) {
                uniqueid.setAttribute("default", "true");
            } else {
                uniqueid.setAttribute("default", "false");
            }
            uniqueid.setTextContent(entry.getValue().toString());
            this.root.appendChild(uniqueid);
        }
    }

    protected void addRating(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        String ratingSource;
        Map<String, MediaRating> ratings = episode.getRatings();
        MediaRating mainMediaRating = null;
        Iterator<Object> iterator = this.settings.getRatingSources().iterator();
        while (iterator.hasNext() && (mainMediaRating = ratings.get(ratingSource = iterator.next())) == null) {
        }
        if (mainMediaRating == null) {
            for (MediaRating r : ratings.values()) {
                if ("user".equals(r.getId())) continue;
                mainMediaRating = r;
            }
        }
        if (mainMediaRating == null) {
            mainMediaRating = MediaMetadata.EMPTY_RATING;
        }
        Float rating10 = mainMediaRating.getMaxValue() > 0 ? Float.valueOf(mainMediaRating.getRating() * 10.0f / (float)mainMediaRating.getMaxValue()) : Float.valueOf(mainMediaRating.getRating());
        Element rating = this.document.createElement("rating");
        rating.setTextContent(String.format(Locale.US, "%.1f", rating10));
        this.root.appendChild(rating);
    }

    protected void addUserrating(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        MediaRating mediaRating = episode.getRating("user");
        Float rating10 = mediaRating.getMaxValue() > 0 ? Float.valueOf(mediaRating.getRating() * 10.0f / (float)mediaRating.getMaxValue()) : Float.valueOf(mediaRating.getRating());
        Element UserRating = this.document.createElement("userrating");
        DecimalFormat df = new DecimalFormat("#.#", DECIMAL_FORMAT_SYMBOLS);
        UserRating.setTextContent(df.format(rating10));
        this.root.appendChild(UserRating);
    }

    protected void addVotes(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element votes = this.document.createElement("votes");
        votes.setTextContent(Integer.toString(episode.getRating().getVotes()));
        this.root.appendChild(votes);
    }

    protected void addPlot(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element plot = this.document.createElement("plot");
        plot.setTextContent(episode.getPlot());
        this.root.appendChild(plot);
    }

    protected void addRuntime(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element runtime = this.document.createElement("runtime");
        int runtimeInMinutes = episode.getRuntimeFromMediaFilesInMinutes();
        if (runtimeInMinutes == 0) {
            runtimeInMinutes = episode.getRuntime();
        }
        runtime.setTextContent(Integer.toString(runtimeInMinutes));
        this.root.appendChild(runtime);
    }

    protected void addThumb(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (this.settings.isNfoWriteArtworkUrls()) {
            Element thumb = this.document.createElement("thumb");
            String thumbUrl = episode.getArtworkUrl(MediaFileType.THUMB);
            if (StringUtils.isNotBlank((CharSequence)thumbUrl)) {
                thumb.setTextContent(thumbUrl);
                this.root.appendChild(thumb);
            }
        }
    }

    protected void addMpaa(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element mpaa = this.document.createElement("mpaa");
        if (episode.getCertification() != null) {
            mpaa.setTextContent(CertificationStyle.formatCertification(episode.getCertification(), this.settings.getCertificationStyle()));
        }
        this.root.appendChild(mpaa);
    }

    protected void addPremiered(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element premiered = this.document.createElement("premiered");
        if (episode.getFirstAired() != null) {
            premiered.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(episode.getFirstAired()));
        }
        this.root.appendChild(premiered);
    }

    protected void addDateAdded(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (!this.settings.isNfoWriteDateAdded()) {
            return;
        }
        Element dateadded = this.document.createElement("dateadded");
        switch (this.settings.getNfoDateAddedField()) {
            case DATE_ADDED: {
                if (episode.getDateAdded() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(episode.getDateAdded()));
                break;
            }
            case FILE_CREATION_DATE: {
                MediaFile mainMediaFile = episode.getMainFile();
                if (mainMediaFile == null || mainMediaFile.getDateCreated() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainMediaFile.getDateCreated()));
                break;
            }
            case FILE_LAST_MODIFIED_DATE: {
                MediaFile mainMediaFile = episode.getMainFile();
                if (mainMediaFile == null || mainMediaFile.getDateLastModified() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mainMediaFile.getDateLastModified()));
                break;
            }
            case RELEASE_DATE: {
                if (episode.getFirstAired() != null) {
                    dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(episode.getFirstAired()));
                    break;
                }
                if (episode.getDateAdded() == null) break;
                dateadded.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(episode.getDateAdded()));
            }
        }
        this.root.appendChild(dateadded);
    }

    protected void addLockdata(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (this.settings.isNfoWriteLockdata()) {
            Element lockdata = this.document.createElement("lockdata");
            lockdata.setTextContent("true");
            this.root.appendChild(lockdata);
        }
    }

    protected void addFileinfo(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (this.settings.isNfoWriteFileinfo()) {
            Element fileinfo = this.document.createElement("fileinfo");
            Element streamdetails = this.document.createElement("streamdetails");
            MediaFile videoFile = episode.getMainVideoFile();
            if (videoFile != MediaFile.EMPTY_MEDIAFILE) {
                Element video = NfoUtils.createStreamdetailsVideoTag(streamdetails, videoFile);
                if (!episode.isDisc() && !episode.getMainVideoFile().getExtension().equalsIgnoreCase("iso")) {
                    Element durationinseconds = this.document.createElement("durationinseconds");
                    durationinseconds.setTextContent(String.valueOf(episode.getRuntimeFromMediaFiles()));
                    video.appendChild(durationinseconds);
                }
                streamdetails.appendChild(video);
                for (MediaFileAudioStream audioStream : videoFile.getAudioStreams()) {
                    Element audio = NfoUtils.createStreamdetailsAudioTag(streamdetails, audioStream);
                    streamdetails.appendChild(audio);
                }
                for (MediaFileSubtitle sub : videoFile.getSubtitles()) {
                    Element subtitle = this.document.createElement("subtitle");
                    Element language = this.document.createElement("language");
                    language.setTextContent(LanguageUtils.parseLanguageFromString(sub.getLanguage()));
                    subtitle.appendChild(language);
                    streamdetails.appendChild(subtitle);
                }
                for (MediaFile mediaFile : episode.getMediaFiles(MediaFileType.SUBTITLE)) {
                    for (MediaFileSubtitle sub : mediaFile.getSubtitles()) {
                        Element subtitle = this.document.createElement("subtitle");
                        Element language = this.document.createElement("language");
                        language.setTextContent(LanguageUtils.parseLanguageFromString(sub.getLanguage()));
                        subtitle.appendChild(language);
                        streamdetails.appendChild(subtitle);
                    }
                }
            }
            fileinfo.appendChild(streamdetails);
            this.root.appendChild(fileinfo);
        }
    }

    protected void addAired(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element premiered = this.document.createElement("aired");
        if (episode.getFirstAired() != null) {
            premiered.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(episode.getFirstAired()));
        }
        this.root.appendChild(premiered);
    }

    protected void addWatched(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element watched = this.document.createElement("watched");
        watched.setTextContent(Boolean.toString(episode.isWatched()));
        this.root.appendChild(watched);
    }

    protected void addPlaycount(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        int playCountFromNFO;
        Element playcount = this.document.createElement("playcount");
        int n = playCountFromNFO = parser != null ? parser.playcount : 0;
        if (episode.isWatched()) {
            playCountFromNFO = Math.max(episode.getPlaycount(), playCountFromNFO);
            if (episode.isWatched()) {
                playCountFromNFO = Math.max(playCountFromNFO, 1);
            }
        } else {
            playCountFromNFO = 0;
        }
        playcount.setTextContent(Integer.toString(playCountFromNFO));
        this.root.appendChild(playcount);
    }

    private void addLastplayed(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Date lastPlayedFromMovie;
        Date lastPlayedFromNFO;
        Date lastPlayedDate;
        Element lastPlayed = this.document.createElement("lastplayed");
        if (episode.isWatched() && (lastPlayedDate = DateUtils.getHigherDate(lastPlayedFromNFO = parser != null ? parser.lastplayed : null, lastPlayedFromMovie = episode.getLastWatched())) != null) {
            lastPlayed.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(lastPlayedDate));
            this.root.appendChild(lastPlayed);
        }
    }

    protected void addStudios(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        for (String s : ParserUtils.split(episode.getProductionCompany())) {
            Element studio = this.document.createElement("studio");
            studio.setTextContent(s);
            this.root.appendChild(studio);
            if (!this.settings.isNfoWriteSingleStudio()) continue;
            break;
        }
    }

    protected void addTags(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        for (String t : episode.getTags()) {
            Element tag = this.document.createElement("tag");
            tag.setTextContent(t);
            this.root.appendChild(tag);
        }
    }

    protected void addCredits(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        for (Person writer : episode.getWriters()) {
            Element element = this.document.createElement("credits");
            element.setTextContent(writer.getName());
            NfoUtils.addPersonIdsAsAttributes(element, writer);
            this.root.appendChild(element);
        }
    }

    protected void addDirectors(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        for (Person director : episode.getDirectors()) {
            Element element = this.document.createElement("director");
            element.setTextContent(director.getName());
            NfoUtils.addPersonIdsAsAttributes(element, director);
            this.root.appendChild(element);
        }
    }

    protected void addActors(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        for (Person tvShowActor : episode.getActors()) {
            Element profile;
            Element actor = this.document.createElement("actor");
            Element name = this.document.createElement("name");
            name.setTextContent(tvShowActor.getName());
            actor.appendChild(name);
            if (StringUtils.isNotBlank((CharSequence)tvShowActor.getRole())) {
                Element role = this.document.createElement("role");
                role.setTextContent(tvShowActor.getRole());
                actor.appendChild(role);
            }
            if (this.settings.isNfoWriteArtworkUrls() && StringUtils.isNotBlank((CharSequence)tvShowActor.getThumbUrl())) {
                Element thumb = this.document.createElement("thumb");
                thumb.setTextContent(tvShowActor.getThumbUrl());
                actor.appendChild(thumb);
            }
            if (StringUtils.isNotBlank((CharSequence)tvShowActor.getProfileUrl())) {
                profile = this.document.createElement("profile");
                profile.setTextContent(tvShowActor.getProfileUrl());
                actor.appendChild(profile);
            }
            if (tvShowActor.getType() == Person.Type.GUEST) {
                profile = this.document.createElement("type");
                profile.setTextContent("GuestStar");
                actor.appendChild(profile);
            }
            NfoUtils.addPersonIdsAsChildren(actor, tvShowActor);
            this.root.appendChild(actor);
        }
    }

    protected void addTrailer(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (this.settings.isNfoWriteAllActors()) {
            Element trailer = this.document.createElement("trailer");
            if (parser != null && StringUtils.isNotBlank((CharSequence)parser.trailer)) {
                trailer.setTextContent(parser.trailer);
            }
            this.root.appendChild(trailer);
        }
    }

    protected void addTinyMediaManagerTags(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        this.root.appendChild(this.document.createComment("tinyMediaManager meta data"));
        this.addSource(episode, parser);
        this.addEdition(episode, parser);
        this.addOriginalFilename(episode, parser);
        this.addUserNote(episode, parser);
        this.addEpisodeGroups(episode, parser);
        this.addEnglishTitle(episode, parser);
        this.addCRC32(episode, parser);
    }

    protected void addSource(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element source = this.document.createElement("source");
        source.setTextContent(episode.getMediaSource().name());
        this.root.appendChild(source);
    }

    protected void addEdition(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element edition = this.document.createElement("edition");
        edition.setTextContent(episode.getEdition().name());
        this.root.appendChild(edition);
    }

    protected void addOriginalFilename(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element originalFilename = this.document.createElement("original_filename");
        if (StringUtils.isBlank((CharSequence)episode.getOriginalFilename())) {
            originalFilename.setTextContent(episode.getMainFile().getFilename());
        } else {
            originalFilename.setTextContent(episode.getOriginalFilename());
        }
        this.root.appendChild(originalFilename);
    }

    protected void addUserNote(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element userNote = this.document.createElement("user_note");
        userNote.setTextContent(episode.getNote());
        this.root.appendChild(userNote);
    }

    protected void addEpisodeGroups(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element episodeGroups = this.document.createElement("episode_groups");
        for (MediaEpisodeNumber episodeNumber : episode.getEpisodeNumbers()) {
            Element group = this.document.createElement("group");
            group.setAttribute("id", episodeNumber.episodeGroup().getEpisodeGroupType().name());
            group.setAttribute("name", episodeNumber.episodeGroup().getName());
            group.setAttribute("season", String.valueOf(episodeNumber.season()));
            group.setAttribute("episode", String.valueOf(episodeNumber.episode()));
            episodeGroups.appendChild(group);
        }
        this.root.appendChild(episodeGroups);
    }

    protected void addEnglishTitle(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (StringUtils.isNotBlank((CharSequence)episode.getEnglishTitle())) {
            Element englishTitle = this.document.createElement("english_title");
            englishTitle.setTextContent(episode.getEnglishTitle());
            this.root.appendChild(englishTitle);
        }
    }

    protected void addCRC32(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (episode.getMainFile() == null || StringUtils.isBlank((CharSequence)episode.getMainFile().getCRC32())) {
            return;
        }
        Element crc = this.document.createElement("crc32");
        crc.setTextContent(episode.getMainFile().getCRC32());
        this.root.appendChild(crc);
    }

    protected void addUnsupportedTags(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (parser != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            for (String unsupportedString : parser.unsupportedElements) {
                try {
                    Document unsupported = factory.newDocumentBuilder().parse(new ByteArrayInputStream(unsupportedString.getBytes(StandardCharsets.UTF_8)));
                    this.root.appendChild(this.document.importNode(unsupported.getFirstChild(), true));
                }
                catch (Exception e) {
                    LOGGER.debug("import unsupported tags: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected Element getSingleElementByTag(String tag) {
        NodeList nodeList = this.document.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }
}

