/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.PostProcessExecutor;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;

public class TvShowPostProcessExecutor
extends PostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowPostProcessExecutor.class);

    public TvShowPostProcessExecutor(PostProcess postProcess, List<TvShow> tvShows) {
        super(postProcess, tvShows);
    }

    @Override
    protected void execute() {
        for (MediaEntity mediaEntity : this.entities) {
            if (!(mediaEntity instanceof TvShow)) continue;
            TvShow tvShow = (TvShow)mediaEntity;
            LOGGER.info("Executing post process '{}' for TV show '{}'", (Object)this.postProcess.getName(), (Object)tvShow.getTitle());
            HashMap<String, Object> mappings = new HashMap<String, Object>();
            mappings.put("tvShow", tvShow);
            String[] command = this.substituteTokens(mappings);
            try {
                this.executeCommand(command, tvShow);
                LOGGER.info("Successfully executed post process '{}' for TV show '{}'", (Object)this.postProcess.getName(), (Object)tvShow.getTitle());
            }
            catch (Exception exception) {}
        }
    }

    private String[] substituteTokens(Map<String, Object> mappings) {
        Engine engine = TvShowRenamer.createEngine();
        engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
        if (this.postProcess.getPath() == null || this.postProcess.getPath().isEmpty()) {
            String transformed = engine.transform(JmteUtils.morphTemplate(this.postProcess.getCommand(), TvShowRenamer.getTokenMap()), mappings);
            return new String[]{transformed};
        }
        String[] splitted = this.postProcess.getCommand().split("\\n");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = engine.transform(JmteUtils.morphTemplate(splitted[i], TvShowRenamer.getTokenMap()), mappings);
        }
        return splitted;
    }
}

