/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.DynaEnum;

public class MovieEdition
extends DynaEnum<MovieEdition> {
    private static final Comparator<MovieEdition> COMPARATOR = new MovieEditionComparator();
    public static final MovieEdition NONE = new MovieEdition("NONE", 0, "", "");
    public static final MovieEdition DIRECTORS_CUT = new MovieEdition("DIRECTORS_CUT", 1, "Director's Cut", ".Director.?s.(Cut|Edition|Version)");
    public static final MovieEdition EXTENDED_EDITION = new MovieEdition("EXTENDED_EDITION", 2, "Extended Edition", ".Extended.(Cut|Edition|Version)?");
    public static final MovieEdition THEATRICAL_EDITION = new MovieEdition("THEATRICAL_EDITION", 3, "Theatrical Edition", ".Theatrical.(Cut|Edition|Version)?");
    public static final MovieEdition UNRATED = new MovieEdition("UNRATED", 4, "Unrated", ".Unrated.(Cut|Edition|Version)?");
    public static final MovieEdition UNCUT = new MovieEdition("UNCUT", 5, "Uncut", ".Uncut.(Cut|Edition|Version)?");
    public static final MovieEdition IMAX = new MovieEdition("IMAX", 6, "IMAX", "^(IMAX|.*?.IMAX).(Cut|Edition|Version)?");
    public static final MovieEdition REMASTERED = new MovieEdition("REMASTERED", 7, "Remastered", ".Remastered.(Cut|Edition|Version)?");
    public static final MovieEdition COLLECTORS_EDITION = new MovieEdition("COLLECTORS_EDITION", 8, "Collectors Edition", ".Collectors.(Cut|Edition|Version)");
    public static final MovieEdition ULTIMATE_EDITION = new MovieEdition("ULTIMATE_EDITION", 9, "Ultimate Edition", ".Ultimate.(Cut|Edition|Version)");
    public static final MovieEdition FINAL_CUT = new MovieEdition("FINAL_CUT", 10, "Final Edition", ".Final.(Cut|Edition|Version)");
    public static final MovieEdition SPECIAL_EDITION = new MovieEdition("SPECIAL_EDITION", 11, "Special Edition", ".Special.(Cut|Edition|Version)");
    public static final MovieEdition CRITERION_COLLECTION = new MovieEdition("CRITERION_COLLECTION", 12, "Criterion Collection", ".Criterion.(Collection|Edition)?");
    public static final MovieEdition OPEN_MATTE = new MovieEdition("OPEN_MATTE", 13, "Open Matte", ".Open.Matte.(Cut|Edition|Version)?");
    private static final Pattern FILENAME_PATTERN = Pattern.compile("\\{edition\\-(.*?)\\}", 2);
    private final String title;
    private final Pattern pattern;

    private MovieEdition(String enumName, int ordinal, String title, String pattern) {
        super(enumName, ordinal);
        this.title = title;
        this.pattern = StringUtils.isBlank((CharSequence)pattern) ? null : Pattern.compile(pattern, 2);
        this.addElement();
    }

    @Override
    public String toString() {
        return this.title;
    }

    public String getTitle() {
        return this.title;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public static MovieEdition[] values() {
        MovieEdition[] movieEditions = MovieEdition.values(MovieEdition.class);
        Arrays.sort(movieEditions, COMPARATOR);
        return movieEditions;
    }

    public static MovieEdition getMovieEditionFromString(String name) {
        List<MovieEdition> editions = Arrays.asList(MovieEdition.values(MovieEdition.class));
        editions.sort(Comparator.comparingInt(o -> o.ordinal));
        for (MovieEdition edition : editions) {
            if (!edition.name().equals(name)) continue;
            return edition;
        }
        for (MovieEdition edition : editions) {
            if (!edition.title.equalsIgnoreCase(name)) continue;
            return edition;
        }
        for (MovieEdition edition : editions) {
            Matcher matcher;
            if (edition.pattern == null || !(matcher = edition.pattern.matcher(name)).find()) continue;
            return edition;
        }
        Matcher matcher = FILENAME_PATTERN.matcher(name);
        if (matcher.find()) {
            MovieEdition me = MovieEdition.getMovieEditionFromString(matcher.group(1));
            if (me == NONE) {
                return new MovieEdition(matcher.group(1), MovieEdition.values().length, matcher.group(1), "");
            }
            return me;
        }
        return NONE;
    }

    public static MovieEdition getMovieEdition(String name) {
        if (StringUtils.isBlank((CharSequence)name) || "NONE".equals(name)) {
            return NONE;
        }
        MovieEdition edition = MovieEdition.getMovieEditionFromString(name);
        if (edition == NONE) {
            edition = new MovieEdition(name, MovieEdition.values().length, name, "");
        }
        return edition;
    }

    @JsonCreator
    public static MovieEdition getMovieEditionStrict(String name) {
        if (StringUtils.isBlank((CharSequence)name) || "NONE".equals(name)) {
            return NONE;
        }
        MovieEdition edition = NONE;
        for (MovieEdition movieEdition : MovieEdition.values()) {
            if (!movieEdition.name().equals(name)) continue;
            edition = movieEdition;
        }
        if (edition == NONE) {
            edition = new MovieEdition(name, MovieEdition.values().length, name, "");
        }
        return edition;
    }

    public static void addListener(DynaEnum.DynaEnumEventListener<MovieEdition> listener) {
        MovieEdition.addListener(MovieEdition.class, listener);
    }

    public static void removeListener(DynaEnum.DynaEnumEventListener<MovieEdition> listener) {
        MovieEdition.removeListener(MovieEdition.class, listener);
    }

    public static class MovieEditionComparator
    implements Comparator<MovieEdition> {
        private final RuleBasedCollator stringCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();

        @Override
        public int compare(MovieEdition o1, MovieEdition o2) {
            if (o1.toString() == null && o2.toString() == null) {
                return 0;
            }
            if (o1.toString() == null) {
                return 1;
            }
            if (o2.toString() == null) {
                return -1;
            }
            return this.stringCollator.compare(o1.toString().toLowerCase(Locale.ROOT), o2.toString().toLowerCase(Locale.ROOT));
        }
    }
}

