/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.iso9660.rrip;

import com.github.stephenc.javaisotools.loopfs.iso9660.Util;
import com.github.stephenc.javaisotools.loopfs.iso9660.rrip.RripSLComponent;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.SuspField;
import com.github.stephenc.javaisotools.loopfs.iso9660.susp.exceptions.InvalidSuspField;
import java.util.List;

public class RripFieldSL
extends SuspField {
    private int flags;
    private String pathname;

    public RripFieldSL() {
    }

    public RripFieldSL(byte[] byArray, int n) throws InvalidSuspField {
        this.deserialize(byArray, n);
    }

    public String getPathname() {
        return this.pathname;
    }

    public boolean isContinuous() {
        return (this.flags & 1) != 0;
    }

    @Override
    public int getExpectedId() {
        return 21324;
    }

    @Override
    public void deserialize(byte[] byArray, int n) throws InvalidSuspField {
        this.deserializeHeader(byArray, n);
        this.verifyId();
        this.flags = Util.getUInt8(byArray, n + 4);
        byte[] byArray2 = Util.getBytes(byArray, n + 4, this.length - 5);
        List<RripSLComponent> list = RripSLComponent.fromComponentArea(byArray2);
        this.pathname = this.extracPathname(list);
    }

    private String extracPathname(List<RripSLComponent> list) throws InvalidSuspField {
        String string = "";
        boolean bl = true;
        for (RripSLComponent rripSLComponent : list) {
            if (!bl) {
                string = string + "/";
            }
            if (rripSLComponent.isNormalLink()) {
                string = string + rripSLComponent.getText();
            }
            if (rripSLComponent.linksToCurrentDir()) {
                string = string + ".";
            }
            if (rripSLComponent.linksToParentDir()) {
                string = string + "..";
            }
            if (rripSLComponent.linksToRootDir() && !bl) {
                throw new InvalidSuspField("unexpected root symlink");
            }
            bl = false;
        }
        return string;
    }
}

