/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.search;

import com.github.kiulian.downloader.model.search.SearchResultChannelDetails;
import com.github.kiulian.downloader.model.search.SearchResultItem;
import com.github.kiulian.downloader.model.search.SearchResultItemType;
import com.github.kiulian.downloader.model.search.SearchResultPlaylistDetails;
import com.github.kiulian.downloader.model.search.SearchResultShelf;
import com.github.kiulian.downloader.model.search.SearchResultVideoDetails;
import com.github.kiulian.downloader.model.search.query.QueryAutoCorrection;
import com.github.kiulian.downloader.model.search.query.QueryElement;
import com.github.kiulian.downloader.model.search.query.QueryElementType;
import com.github.kiulian.downloader.model.search.query.QueryRefinementList;
import com.github.kiulian.downloader.model.search.query.QuerySuggestion;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SearchResult {
    private final long estimatedResults;
    private final List<SearchResultItem> items;
    private final QuerySuggestion suggestion;
    private final QueryRefinementList refinementList;
    private final String autoCorrectedQuery;

    public SearchResult(long l, List<SearchResultItem> list, Map<QueryElementType, QueryElement> map) {
        this.estimatedResults = l;
        this.items = list;
        this.suggestion = (QuerySuggestion)map.get((Object)QueryElementType.SUGGESTION);
        this.refinementList = (QueryRefinementList)map.get((Object)QueryElementType.REFINEMENT_LIST);
        this.autoCorrectedQuery = map.containsKey((Object)QueryElementType.AUTO_CORRECTION) ? ((QueryAutoCorrection)map.get((Object)QueryElementType.AUTO_CORRECTION)).query() : null;
    }

    public QuerySuggestion suggestion() {
        return this.suggestion;
    }

    public QueryRefinementList refinements() {
        return this.refinementList;
    }

    public boolean isAutoCorrected() {
        return this.autoCorrectedQuery != null;
    }

    public String autoCorrectedQuery() {
        return this.autoCorrectedQuery;
    }

    public List<SearchResultVideoDetails> videos() {
        LinkedList<SearchResultVideoDetails> linkedList = new LinkedList<SearchResultVideoDetails>();
        for (SearchResultItem searchResultItem : this.items) {
            if (searchResultItem.type() != SearchResultItemType.VIDEO) continue;
            linkedList.add(searchResultItem.asVideo());
        }
        return linkedList;
    }

    public List<SearchResultChannelDetails> channels() {
        LinkedList<SearchResultChannelDetails> linkedList = new LinkedList<SearchResultChannelDetails>();
        for (SearchResultItem searchResultItem : this.items) {
            if (searchResultItem.type() != SearchResultItemType.CHANNEL) continue;
            linkedList.add(searchResultItem.asChannel());
        }
        return linkedList;
    }

    public List<SearchResultPlaylistDetails> playlists() {
        LinkedList<SearchResultPlaylistDetails> linkedList = new LinkedList<SearchResultPlaylistDetails>();
        for (SearchResultItem searchResultItem : this.items) {
            if (searchResultItem.type() != SearchResultItemType.PLAYLIST) continue;
            linkedList.add(searchResultItem.asPlaylist());
        }
        return linkedList;
    }

    public List<SearchResultShelf> shelves() {
        LinkedList<SearchResultShelf> linkedList = new LinkedList<SearchResultShelf>();
        for (SearchResultItem searchResultItem : this.items) {
            if (searchResultItem.type() != SearchResultItemType.SHELF) continue;
            linkedList.add(searchResultItem.asShelf());
        }
        return linkedList;
    }

    public boolean hasContinuation() {
        return false;
    }

    public long estimatedResults() {
        return this.estimatedResults;
    }

    public List<SearchResultItem> items() {
        return this.items;
    }
}

