/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.container;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.PersonWithRole;
import org.jupnp.support.model.container.Album;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.item.Item;
import org.jupnp.support.model.item.MusicTrack;

public class MusicAlbum
extends Album {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.container.album.musicAlbum");

    public MusicAlbum() {
        this.setClazz(CLASS);
    }

    public MusicAlbum(Container other) {
        super(other);
    }

    public MusicAlbum(String id, Container parent, String title, String creator, Integer childCount) {
        this(id, parent.getId(), title, creator, childCount, new ArrayList<MusicTrack>());
    }

    public MusicAlbum(String id, Container parent, String title, String creator, Integer childCount, List<MusicTrack> musicTracks) {
        this(id, parent.getId(), title, creator, childCount, musicTracks);
    }

    public MusicAlbum(String id, String parentID, String title, String creator, Integer childCount) {
        this(id, parentID, title, creator, childCount, new ArrayList<MusicTrack>());
    }

    public MusicAlbum(String id, String parentID, String title, String creator, Integer childCount, List<MusicTrack> musicTracks) {
        super(id, parentID, title, creator, childCount);
        this.setClazz(CLASS);
        this.addMusicTracks(musicTracks);
    }

    public PersonWithRole getFirstArtist() {
        return (PersonWithRole)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ARTIST.class);
    }

    public PersonWithRole[] getArtists() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.ARTIST.class);
        return list.toArray(new PersonWithRole[list.size()]);
    }

    public MusicAlbum setArtists(PersonWithRole[] artists) {
        this.removeProperties(DIDLObject.Property.UPNP.ARTIST.class);
        for (PersonWithRole artist : artists) {
            this.addProperty(new DIDLObject.Property.UPNP.ARTIST(artist));
        }
        return this;
    }

    public String getFirstGenre() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.GENRE.class);
    }

    public String[] getGenres() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.GENRE.class);
        return list.toArray(new String[list.size()]);
    }

    public MusicAlbum setGenres(String[] genres) {
        this.removeProperties(DIDLObject.Property.UPNP.GENRE.class);
        for (String genre : genres) {
            this.addProperty(new DIDLObject.Property.UPNP.GENRE(genre));
        }
        return this;
    }

    public Person getFirstProducer() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.UPNP.PRODUCER.class);
    }

    public Person[] getProducers() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.PRODUCER.class);
        return list.toArray(new Person[list.size()]);
    }

    public MusicAlbum setProducers(Person[] persons) {
        this.removeProperties(DIDLObject.Property.UPNP.PRODUCER.class);
        for (Person p : persons) {
            this.addProperty(new DIDLObject.Property.UPNP.PRODUCER(p));
        }
        return this;
    }

    public URI getFirstAlbumArtURI() {
        return (URI)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ALBUM_ART_URI.class);
    }

    public URI[] getAlbumArtURIs() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.ALBUM_ART_URI.class);
        return list.toArray(new URI[list.size()]);
    }

    public MusicAlbum setAlbumArtURIs(URI[] uris) {
        this.removeProperties(DIDLObject.Property.UPNP.ALBUM_ART_URI.class);
        for (URI uri : uris) {
            this.addProperty(new DIDLObject.Property.UPNP.ALBUM_ART_URI(uri));
        }
        return this;
    }

    public String getToc() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.TOC.class);
    }

    public MusicAlbum setToc(String toc) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.TOC(toc));
        return this;
    }

    public MusicTrack[] getMusicTracks() {
        ArrayList<MusicTrack> list = new ArrayList<MusicTrack>();
        for (Item item : this.getItems()) {
            if (!(item instanceof MusicTrack)) continue;
            list.add((MusicTrack)item);
        }
        return list.toArray(new MusicTrack[list.size()]);
    }

    public void addMusicTracks(List<MusicTrack> musicTracks) {
        this.addMusicTracks(musicTracks.toArray(new MusicTrack[musicTracks.size()]));
    }

    public void addMusicTracks(MusicTrack[] musicTracks) {
        if (musicTracks != null) {
            for (MusicTrack musicTrack : musicTracks) {
                musicTrack.setAlbum(this.getTitle());
                this.addItem(musicTrack);
            }
        }
    }
}

