/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;
import org.tinymediamanager.ui.tvshows.TvShowTreeNodeComparator;

public class TvShowTreeDataProvider
extends TmmTreeDataProvider<TmmTreeNode> {
    private final TmmTreeNode root = new TmmTreeNode(new Object(), this);
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    public TvShowTreeDataProvider(TmmTreeTableFormat<TmmTreeNode> tableFormat) {
        EventBus.registerListener(EventBus.TOPIC_TV_SHOWS, event -> {
            Object patt2127$temp = event.sender();
            if (patt2127$temp instanceof TvShow) {
                TvShow tvShow = (TvShow)patt2127$temp;
                this.processTvShow(tvShow, event.eventType());
            } else {
                Object patt2243$temp = event.sender();
                if (patt2243$temp instanceof TvShowSeason) {
                    TvShowSeason season = (TvShowSeason)patt2243$temp;
                    this.processSeason(season, event.eventType());
                } else {
                    Object patt2365$temp = event.sender();
                    if (patt2365$temp instanceof TvShowEpisode) {
                        TvShowEpisode episode = (TvShowEpisode)patt2365$temp;
                        this.processEpisode(episode, event.eventType());
                    }
                }
            }
        });
        this.setTreeComparator(new TvShowTreeNodeComparator(tableFormat));
        TvShowModuleManager.getInstance().getSettings().addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "displayMissingEpisodes": 
                case "displayMissingSpecials": 
                case "displayMissingNotAired": {
                    this.updateDummyEpisodes();
                }
            }
        });
    }

    private void processTvShow(TvShow tvShow, String eventType) {
        if (!this.tvShowList.getTvShows().contains(tvShow)) {
            this.removeTvShow(tvShow);
            return;
        }
        TmmTreeNode tvShowNode = this.getNodeFromCache(tvShow);
        if (tvShowNode != null) {
            if ("remove".equals(eventType)) {
                this.removeTvShow(tvShow);
            } else {
                this.nodeChanged(tvShow);
                this.updateDummyEpisodes();
            }
        } else {
            this.addTvShow(tvShow);
        }
    }

    private void processSeason(TvShowSeason season, String eventType) {
        this.updateSeason(season);
    }

    private void processEpisode(TvShowEpisode episode, String eventType) {
        if ("remove".equals(eventType)) {
            this.removeTvShowEpisode(episode);
        } else {
            this.updateEpisode(episode);
        }
        this.updateDummyEpisodesForTvShow(episode.getTvShow());
    }

    private void updateSeason(TvShowSeason season) {
        if (!this.tvShowList.getTvShows().contains(season.getTvShow()) || !season.getTvShow().getSeasons().contains(season)) {
            this.removeTvShowSeason(season);
            return;
        }
        TmmTreeNode seasonNode = this.getNodeFromCache(season);
        if (seasonNode == null) {
            seasonNode = this.addTvShowSeason(season);
        }
        if (seasonNode != null) {
            this.updateSeason(seasonNode);
        }
    }

    private void updateSeason(TmmTreeNode seasonNode) {
        Object object = seasonNode.getUserObject();
        if (object instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)object;
            if (seasonNode.getChildCount() == 0) {
                TmmTreeNode cachedNode = this.removeNodeFromCache(season);
                if (cachedNode == null) {
                    return;
                }
                this.firePropertyChange("nodeRemoved", null, cachedNode);
            } else {
                List<TvShowEpisode> episodesForDisplay = season.getEpisodesForDisplay();
                Enumeration<TreeNode> e = seasonNode.children();
                while (e.hasMoreElements()) {
                    TvShowEpisode episode;
                    TmmTreeNode tmmTreeNode;
                    Object object2;
                    TreeNode child = e.nextElement();
                    if (!(child instanceof TmmTreeNode) || !((object2 = (tmmTreeNode = (TmmTreeNode)child).getUserObject()) instanceof TvShowEpisode) || episodesForDisplay.contains(episode = (TvShowEpisode)object2)) continue;
                    this.removeTvShowEpisode(episode);
                }
                for (TvShowEpisode episode : episodesForDisplay) {
                    this.addTvShowEpisode(episode);
                }
            }
        }
    }

    private void updateEpisode(TvShowEpisode episode) {
        TmmTreeNode episodeNode = this.getNodeFromCache(episode);
        if (episodeNode == null) {
            this.removeTvShowEpisode(episode);
            this.addTvShowEpisode(episode);
        } else {
            TmmTreeNode seasonNodeUi = (TmmTreeNode)episodeNode.getParent();
            TmmTreeNode seasonNodeBean = this.getNodeFromCache(episode.getTvShowSeason());
            if (seasonNodeUi == null || seasonNodeUi != seasonNodeBean) {
                this.removeTvShowEpisode(episode);
                this.addTvShowEpisode(episode);
            } else {
                this.firePropertyChange("nodeChanged", null, episodeNode);
            }
        }
    }

    private void updateDummyEpisodes() {
        for (TvShow tvShow : this.tvShowList.getTvShows()) {
            this.updateDummyEpisodesForTvShow(tvShow);
        }
    }

    private void updateDummyEpisodesForTvShow(TvShow tvShow) {
        List<TvShowEpisode> dummyEpisodes = tvShow.getDummyEpisodes();
        List<TvShowEpisode> episodesForDisplay = tvShow.getEpisodesForDisplay();
        for (TvShowEpisode episode : dummyEpisodes) {
            if (episodesForDisplay.contains(episode) && this.getNodeFromCache(episode) == null) {
                this.addTvShowEpisode(episode);
                continue;
            }
            if (episodesForDisplay.contains(episode) || this.getNodeFromCache(episode) == null) continue;
            this.removeTvShowEpisode(episode);
        }
    }

    private void nodeChanged(Object source) {
        this.nodeChanged(this.getNodeFromCache(source));
    }

    private void nodeChanged(TmmTreeNode node) {
        if (node != null) {
            this.firePropertyChange("nodeChanged", null, node);
        }
    }

    @Override
    public TmmTreeNode getRoot() {
        return this.root;
    }

    @Override
    public TmmTreeNode getParent(TmmTreeNode child) {
        Object node;
        if (child.getUserObject() instanceof TvShow) {
            return this.root;
        }
        Object object = child.getUserObject();
        if (object instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)object;
            node = this.getNodeFromCache(season.getTvShow());
            if (node == null) {
                node = this.addTvShow(season.getTvShow());
            }
            return node;
        }
        node = child.getUserObject();
        if (node instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)node;
            if ((node = this.getNodeFromCache(episode.getTvShowSeason())) == null) {
                node = this.addTvShowSeason(episode.getTvShowSeason());
            }
            if (this.getNodeFromCache(episode.getTvShow()) == null) {
                this.addTvShow(episode.getTvShow());
            }
            return node;
        }
        return null;
    }

    @Override
    public List<TmmTreeNode> getChildren(TmmTreeNode parent) {
        if (parent == this.root) {
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (TvShow tvShow : new ArrayList<TvShow>(this.tvShowList.getTvShows())) {
                nodes.add(this.getOrCreateNode(tvShow));
            }
            return nodes;
        }
        Object nodes = parent.getUserObject();
        if (nodes instanceof TvShow) {
            TvShow tvShow = (TvShow)nodes;
            nodes = new ArrayList<TmmTreeNode>();
            for (TvShowSeason season : tvShow.getSeasons()) {
                if (season.getEpisodesForDisplay().isEmpty()) continue;
                nodes.add((TmmTreeNode)this.getOrCreateNode(season));
            }
            return nodes;
        }
        nodes = parent.getUserObject();
        if (nodes instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)nodes;
            nodes = new ArrayList();
            for (TvShowEpisode episode : season.getEpisodesForDisplay()) {
                nodes.add((TmmTreeNode)this.getOrCreateNode(episode));
            }
            return nodes;
        }
        return null;
    }

    @Override
    public boolean isLeaf(TmmTreeNode node) {
        return node.getUserObject() instanceof TvShowEpisode;
    }

    private TmmTreeNode addTvShow(TvShow tvShow) {
        TmmTreeNode cachedNode = this.getNodeFromCache(tvShow);
        if (cachedNode != null) {
            return cachedNode;
        }
        TvShowTreeNode node = new TvShowTreeNode((Object)tvShow, this);
        this.putNodeToCache(tvShow, node);
        this.firePropertyChange("nodeInserted", null, node);
        return node;
    }

    private void removeTvShow(TvShow tvShow) {
        TmmTreeNode cachedNode = this.removeNodeFromCache(tvShow);
        if (cachedNode == null) {
            return;
        }
        for (TvShowSeason season : tvShow.getSeasons()) {
            this.removeNodeFromCache(season);
        }
        for (TvShowEpisode episode : tvShow.getEpisodesForDisplay()) {
            this.removeNodeFromCache(episode);
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    private TmmTreeNode getOrCreateNode(MediaEntity entity) {
        TmmTreeNode cachedNode = this.getNodeFromCache(entity);
        if (cachedNode != null) {
            return cachedNode;
        }
        if (entity instanceof TvShow) {
            TvShow tvShow = (TvShow)entity;
            TvShowTreeNode node = new TvShowTreeNode((Object)tvShow, this);
            this.putNodeToCache(tvShow, node);
            return node;
        }
        if (entity instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)entity;
            TvShowSeasonTreeNode node = new TvShowSeasonTreeNode((Object)season, this);
            this.putNodeToCache(season, node);
            return node;
        }
        if (entity instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)entity;
            TvShowEpisodeTreeNode node = new TvShowEpisodeTreeNode((Object)episode, this);
            this.putNodeToCache(episode, node);
            return node;
        }
        throw new IllegalArgumentException();
    }

    private TmmTreeNode addTvShowSeason(TvShowSeason season) {
        TmmTreeNode cachedNode = this.getNodeFromCache(season);
        if (cachedNode != null) {
            return cachedNode;
        }
        if (!season.getEpisodesForDisplay().isEmpty()) {
            TvShowSeasonTreeNode node = new TvShowSeasonTreeNode((Object)season, this);
            this.putNodeToCache(season, node);
            this.firePropertyChange("nodeInserted", null, node);
            return node;
        }
        return null;
    }

    private void addTvShowEpisode(TvShowEpisode episode) {
        TmmTreeNode cachedNode = this.getNodeFromCache(episode);
        if (cachedNode != null) {
            return;
        }
        TmmTreeNode seasonNode = this.getNodeFromCache(episode.getTvShowSeason());
        if (seasonNode == null) {
            this.addTvShowSeason(episode.getTvShowSeason());
        }
        TvShowEpisodeTreeNode node = new TvShowEpisodeTreeNode((Object)episode, this);
        this.putNodeToCache(episode, node);
        this.firePropertyChange("nodeInserted", null, node);
    }

    private void removeTvShowEpisode(TvShowEpisode episode) {
        TmmTreeNode cachedNode = this.removeNodeFromCache(episode);
        if (cachedNode != null) {
            TvShowSeason season;
            Object object;
            TmmTreeNode seasonNode = (TmmTreeNode)cachedNode.getParent();
            this.firePropertyChange("nodeRemoved", null, cachedNode);
            if (seasonNode != null && (object = seasonNode.getUserObject()) instanceof TvShowSeason && (season = (TvShowSeason)object).getEpisodesForDisplay().isEmpty()) {
                this.removeTvShowSeason(season);
            }
        }
    }

    private void removeTvShowSeason(TvShowSeason season) {
        TmmTreeNode cachedNode = this.removeNodeFromCache(season);
        if (cachedNode == null) {
            return;
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    public static class TvShowTreeNode
    extends AbstractTvShowTreeNode {
        TvShowTreeNode(Object userObject, TmmTreeDataProvider<TmmTreeNode> dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            Object object = this.getUserObject();
            if (object instanceof TvShow) {
                TvShow tvShow = (TvShow)object;
                return tvShow.getTitleSortable();
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            Object object = this.getUserObject();
            if (object instanceof TvShow) {
                TvShow tvShow = (TvShow)object;
                return tvShow.getTitle();
            }
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            Object object = this.getUserObject();
            if (object instanceof TvShow) {
                TvShow tvShow = (TvShow)object;
                return tvShow.getOriginalTitle();
            }
            return this.toString();
        }

        @Override
        String getEnglishTitle() {
            Object object = this.getUserObject();
            if (object instanceof TvShow) {
                TvShow tvShow = (TvShow)object;
                return tvShow.getEnglishTitle();
            }
            return this.toString();
        }
    }

    public static class TvShowSeasonTreeNode
    extends AbstractTvShowTreeNode {
        public TvShowSeasonTreeNode(Object userObject, TmmTreeDataProvider<TmmTreeNode> dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            Object object = this.getUserObject();
            if (object instanceof TvShowSeason) {
                TvShowSeason season = (TvShowSeason)object;
                if (season.getSeason() == -1) {
                    return TmmResourceBundle.getString("tvshow.uncategorized");
                }
                Object title = "";
                title = season.getSeason() == 0 ? TmmResourceBundle.getString("metatag.specials") : TmmResourceBundle.getString("metatag.season") + " " + season.getSeason();
                if (StringUtils.isNotBlank((CharSequence)season.getTitle()) && !((String)title).strip().equalsIgnoreCase(season.getTitle().strip())) {
                    title = (String)title + " - " + season.getTitle();
                }
                return title;
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            return this.toString();
        }

        @Override
        String getEnglishTitle() {
            return this.toString();
        }
    }

    public static class TvShowEpisodeTreeNode
    extends AbstractTvShowTreeNode {
        public TvShowEpisodeTreeNode(Object userObject, TmmTreeDataProvider<TmmTreeNode> dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            Object object = this.getUserObject();
            if (object instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)object;
                if (episode.getEpisode() >= 0) {
                    return episode.getEpisode() + ". " + episode.getTitle();
                }
                return episode.getTitleSortable();
            }
            return super.toString();
        }

        @Override
        public String getTitle() {
            Object object = this.getUserObject();
            if (object instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)object;
                return episode.getTitle();
            }
            return this.toString();
        }

        @Override
        public String getOriginalTitle() {
            Object object = this.getUserObject();
            if (object instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)object;
                return episode.getOriginalTitle();
            }
            return this.toString();
        }

        @Override
        String getEnglishTitle() {
            Object object = this.getUserObject();
            if (object instanceof TvShowEpisode) {
                TvShowEpisode episode = (TvShowEpisode)object;
                return episode.getEnglishTitle();
            }
            return this.toString();
        }
    }

    static abstract class AbstractTvShowTreeNode
    extends TmmTreeNode {
        AbstractTvShowTreeNode(Object userObject, TmmTreeDataProvider<TmmTreeNode> dataProvider) {
            super(userObject, dataProvider);
        }

        abstract String getTitle();

        abstract String getOriginalTitle();

        abstract String getEnglishTitle();
    }
}

