/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.moviesets.MovieSetSelectionModel;
import org.tinymediamanager.ui.panels.ImagePanel;

public class MovieSetArtworkPanel
extends JPanel {
    private final List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private ImagePanel imagePanel;

    public MovieSetArtworkPanel(MovieSetSelectionModel selectionModel) {
        EnumMap artworkMap = new EnumMap(MediaFileType.class);
        this.initComponents();
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != MovieSetSelectionModel.class) {
                return;
            }
            if ("selectedMovieSet".equals(property) || "mediaFiles".equals(property)) {
                List<MediaFile> list = this.mediaFiles;
                synchronized (list) {
                    this.mediaFiles.clear();
                    artworkMap.clear();
                    for (MediaFile mediafile : selectionModel.getSelectedMovieSet().getMediaFiles()) {
                        if (!mediafile.isGraphic()) continue;
                        artworkMap.put(mediafile.getType(), mediafile);
                    }
                    this.mediaFiles.addAll(artworkMap.values());
                    this.imagePanel.rebuildPanel();
                }
            }
        };
        selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[400lp,grow]", "[300lp:400lp,grow]"));
        this.imagePanel = new ImagePanel(this.mediaFiles);
        this.imagePanel.setMaxWidth(400);
        this.imagePanel.setMaxHeight(200);
        this.add((Component)this.imagePanel, "cell 0 0,grow");
    }
}

