/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCellRenderer;
import org.tinymediamanager.ui.moviesets.MovieSetTreeDataProvider;

public class MovieSetTreeCellRenderer
extends TmmTreeTableCellRenderer {
    private Color colorDummy;

    @Override
    public void updateUI() {
        super.updateUI();
        this.colorDummy = UIManager.getColor("Component.linkColor");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof MovieSetTreeDataProvider.MovieTreeNode) {
            if (((MovieSetTreeDataProvider.MovieTreeNode)value).getUserObject() instanceof MovieSet.MovieSetMovie) {
                renderer.setForeground(this.colorDummy);
            }
            if (((MovieSetTreeDataProvider.MovieTreeNode)value).getUserObject() instanceof Movie) {
                Movie movie = (Movie)((MovieSetTreeDataProvider.MovieTreeNode)value).getUserObject();
                if (movie.isLocked()) {
                    this.setIcon(IconManager.LOCK_BLUE);
                } else {
                    this.setIcon(null);
                }
            }
        }
        return renderer;
    }

    @Override
    public String getToolTipText() {
        if (!MovieModuleManager.getInstance().getSettings().isShowMovieSetTableTooltips()) {
            return null;
        }
        return super.getToolTipText();
    }
}

