/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAudioLanguageFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    private MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieAudioLanguageFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAudioLanguageArray();
        this.movieList.addPropertyChangeListener("audioLanugages", evt -> SwingUtilities.invokeLater(this::buildAudioLanguageArray));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.language"));
    }

    @Override
    public String getId() {
        return "movieAudioLanguage";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        List<MediaFile> mediaFileList = movie.getMediaFiles(MediaFileType.VIDEO);
        for (MediaFile mf : mediaFileList) {
            if (selectedItems.isEmpty() && mf.getAudioLanguagesList().isEmpty()) {
                return true;
            }
            for (String lang : mf.getAudioLanguagesList()) {
                if (!selectedItems.contains(lang)) continue;
                return true;
            }
        }
        return false;
    }

    private void buildAudioLanguageArray() {
        ArrayList<String> audioLanguages = new ArrayList<String>(this.movieList.getAudioLanguagesInMovies());
        Collections.sort(audioLanguages);
        this.setValues(audioLanguages);
    }
}

