/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.AtcTimeSequence;

@XmlType(propOrder={"start", "number", "offset", "atcTimeSequence"})
public class AtcSequence {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtcSequence.class);
    private int start;
    private byte number;
    private byte offset;
    private AtcTimeSequence[] atcTimeSequence;

    public int size() {
        return 6 + (this.number > 0 ? this.atcTimeSequence[0].size() * this.number : 0);
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public byte getNumber() {
        return this.number;
    }

    public void setNumber(byte by) {
        this.number = by;
    }

    public byte getOffset() {
        return this.offset;
    }

    public void setOffset(byte by) {
        this.offset = by;
    }

    @XmlElement(name="AtcTimeSequence")
    public AtcTimeSequence[] getAtcTimeSequence() {
        return this.atcTimeSequence;
    }

    public void setAtcTimeSequence(AtcTimeSequence[] atcTimeSequenceArray) {
        this.atcTimeSequence = atcTimeSequenceArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        this.start = dataInputStream.readInt();
        LOGGER.trace("AtcSequence start=" + this.start);
        this.number = dataInputStream.readByte();
        LOGGER.trace("AtcSequence number=" + this.number);
        this.offset = dataInputStream.readByte();
        LOGGER.trace("AtcSequence offset=" + this.offset);
        this.atcTimeSequence = new AtcTimeSequence[this.number];
        for (int i = 0; i < this.number; ++i) {
            this.atcTimeSequence[i] = new AtcTimeSequence();
            this.atcTimeSequence[i].readObject(dataInputStream);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.start);
        dataOutputStream.writeByte(this.number);
        dataOutputStream.writeByte(this.offset);
        for (int i = 0; i < this.number; ++i) {
            this.atcTimeSequence[i].writeObject(dataOutputStream);
        }
    }
}

