/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieSetScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.filenaming.IMovieSetFileNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetPosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieSetThumbNaming;
import org.tinymediamanager.core.tasks.MediaFileInformationFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.http.Url;

public class MovieSetArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieSetArtworkHelper.class);
    private static final List<MediaFileType> SUPPORTED_ARTWORK_TYPES = Arrays.asList(MediaFileType.POSTER, MediaFileType.FANART, MediaFileType.BANNER, MediaFileType.CLEARLOGO, MediaFileType.CLEARART, MediaFileType.THUMB, MediaFileType.DISC);
    private static final String[] SUPPORTED_ARTWORK_FILETYPES = new String[]{"jpg", "png", "tbn", "webp"};

    private MovieSetArtworkHelper() {
        throw new IllegalAccessError();
    }

    public static void updateArtwork(MovieSet movieSet) {
        MovieSetArtworkHelper.findArtworkInArtworkFolder(movieSet);
        for (Movie movie : new ArrayList<Movie>(movieSet.getMovies())) {
            MovieSetArtworkHelper.findArtworkInMovieFolder(movieSet, movie);
        }
    }

    public static void cleanupArtwork(MovieSet movieSet) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        ArrayList<MediaFile> cleanup = new ArrayList<MediaFile>();
        TreeSet<MediaFile> needed = new TreeSet<MediaFile>();
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            MediaFile artworkFile;
            List<IMovieSetFileNaming> fileNamings = MovieSetArtworkHelper.getFileNamingsForMediaFileType(type);
            if (fileNamings.isEmpty()) continue;
            List<MediaFile> mediaFiles = movieSet.getMediaFiles(type);
            cleanup.addAll(mediaFiles);
            if ((mediaFiles = mediaFiles.stream().filter(mf -> {
                if (mf.getFilesize() == 0L) {
                    return false;
                }
                return Files.exists(mf.getFile(), new LinkOption[0]);
            }).toList()).isEmpty() || (artworkFile = MovieSetArtworkHelper.getArtworkFromMediaFiles(movieSet, mediaFiles, type, fileNamings)) == null) continue;
            for (Path path : MovieSetArtworkHelper.createArtworkPathsInArtworkFolder(movieSet, fileNamings, artworkFile.getExtension())) {
                try {
                    MediaFile newFile = new MediaFile(artworkFile);
                    newFile.setFile(path);
                    boolean ok = MovieRenamer.copyFile(artworkFile.getFileAsPath(), newFile.getFileAsPath());
                    if (ok) {
                        needed.add(newFile);
                        continue;
                    }
                    needed.add(artworkFile);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not write movie set artwork files", (Throwable)e);
                }
            }
            for (IMovieSetFileNaming filenaming : fileNamings) {
                if (filenaming.getFolderLocation() != IMovieSetFileNaming.Location.MOVIE_FOLDER) continue;
                String filename = filenaming.getFilename("", artworkFile.getExtension());
                for (Movie movie : movieSet.getMovies()) {
                    try {
                        if (!movie.isMultiMovieDir()) {
                            MediaFile newFile = new MediaFile(artworkFile);
                            newFile.setFile(movie.getPathNIO().resolve(filename));
                            boolean ok = MovieRenamer.copyFile(artworkFile.getFileAsPath(), newFile.getFileAsPath());
                            if (ok) {
                                needed.add(newFile);
                                continue;
                            }
                            needed.add(artworkFile);
                            continue;
                        }
                        LOGGER.trace("not writing movie set artwork file to MMD - '{}'", (Object)movie.getPathNIO());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not write movie set artwork files", (Throwable)e);
                    }
                }
            }
        }
        if (!needed.isEmpty() && Settings.getInstance().isImageCache()) {
            needed.forEach(ImageCache::cacheImageAsync);
        }
        cleanup.forEach(movieSet::removeFromMediaFiles);
        movieSet.addToMediaFiles(new ArrayList<MediaFile>(needed));
        for (int i = cleanup.size() - 1; i >= 0; --i) {
            MediaFile cl = (MediaFile)cleanup.get(i);
            if (needed.contains(cl)) continue;
            LOGGER.debug("Deleting {}", (Object)cl.getFileAsPath());
            Utils.deleteFileSafely(cl.getFileAsPath());
            ImageCache.invalidateCachedImage(cl);
            try {
                if (artworkFolder == null || artworkFolder.equals(cl.getFile().getParent()) || !Utils.isFolderEmpty(cl.getFile().getParent())) continue;
                LOGGER.debug("Deleting empty Directory {}", (Object)cl.getFileAsPath().getParent());
                Files.delete(cl.getFileAsPath().getParent());
                continue;
            }
            catch (IOException e) {
                LOGGER.debug("could not search for empty dir: {}", (Object)e.getMessage());
            }
        }
        movieSet.saveToDb();
    }

    private static Path getArtworkFolder() {
        String artworkFolder = MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder();
        if (StringUtils.isBlank((CharSequence)artworkFolder)) {
            return null;
        }
        return Paths.get(artworkFolder, new String[0]);
    }

    private static List<Path> createArtworkPathsInArtworkFolder(MovieSet movieSet, List<IMovieSetFileNaming> filenamings, String extension) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        if (artworkFolder == null) {
            return Collections.emptyList();
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        String movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet);
        for (IMovieSetFileNaming fileNaming : filenamings) {
            if (fileNaming.getFolderLocation() == IMovieSetFileNaming.Location.KODI_STYLE_FOLDER) {
                paths.add(Paths.get(artworkFolder.toString(), movieSetName, fileNaming.getFilename(movieSetName, extension)));
                continue;
            }
            if (fileNaming.getFolderLocation() != IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER) continue;
            paths.add(Paths.get(artworkFolder.toString(), fileNaming.getFilename(movieSetName, extension)));
        }
        return paths;
    }

    private static MediaFile getArtworkFromMediaFiles(MovieSet movieSet, List<MediaFile> mediaFiles, MediaFileType type, List<IMovieSetFileNaming> fileNamings) {
        Path artworkFolder = MovieSetArtworkHelper.getArtworkFolder();
        if (artworkFolder != null) {
            for (IMovieSetFileNaming fileNaming : fileNamings) {
                for (MediaFile mediaFile : mediaFiles) {
                    String movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
                    movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
                    if (MovieSetArtworkHelper.isMediaFileInArtworkFolder(movieSetName = movieSetName.replaceAll(" +", " ").strip(), artworkFolder, fileNaming, mediaFile)) {
                        return mediaFile;
                    }
                    movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet, "_");
                    if (MovieSetArtworkHelper.isMediaFileInArtworkFolder(movieSetName, artworkFolder, fileNaming, mediaFile)) {
                        return mediaFile;
                    }
                    movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet, " ");
                    if (!MovieSetArtworkHelper.isMediaFileInArtworkFolder(movieSetName, artworkFolder, fileNaming, mediaFile)) continue;
                    return mediaFile;
                }
            }
        }
        for (MediaFile mediaFile : mediaFiles) {
            if (mediaFile.getType() != type) continue;
            return mediaFile;
        }
        return null;
    }

    private static boolean isMediaFileInArtworkFolder(String cleanMovieSetName, Path artworkFolder, IMovieSetFileNaming fileNaming, MediaFile mediaFile) {
        if (fileNaming.getFolderLocation() == IMovieSetFileNaming.Location.KODI_STYLE_FOLDER) {
            Path path = Paths.get(artworkFolder.toString(), cleanMovieSetName, fileNaming.getFilename(cleanMovieSetName, ""));
            return mediaFile.getFileAsPath().toAbsolutePath().startsWith(path);
        }
        if (fileNaming.getFolderLocation() == IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER) {
            Path path = Paths.get(artworkFolder.toString(), fileNaming.getFilename(cleanMovieSetName, ""));
            return mediaFile.getFileAsPath().toAbsolutePath().startsWith(path);
        }
        return mediaFile.getFilename().contains(fileNaming.getFilename("", ""));
    }

    private static void findArtworkInArtworkFolder(MovieSet movieSet) {
        String movieSetName;
        String artworkFolder = MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{artworkFolder, movieSet.getTitle()})) {
            return;
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
            movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
            movieSetName = movieSetName.replaceAll(" +", " ").strip();
            MovieSetArtworkHelper.findArtworkForType(movieSet, artworkFolder, movieSetName, type);
            movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet, "_");
            MovieSetArtworkHelper.findArtworkForType(movieSet, artworkFolder, movieSetName, type);
            movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet, " ");
            MovieSetArtworkHelper.findArtworkForType(movieSet, artworkFolder, movieSetName, type);
        }
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
            movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
            movieSetName = movieSetName.replaceAll(" +", " ").strip();
            MovieSetArtworkHelper.findArtworkForType(movieSet, artworkFolder + File.separator + movieSetName, movieSetName, type);
            movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet, "_");
            MovieSetArtworkHelper.findArtworkForType(movieSet, artworkFolder, movieSetName, type);
            movieSetName = MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet, " ");
            MovieSetArtworkHelper.findArtworkForType(movieSet, artworkFolder, movieSetName, type);
        }
    }

    private static void findArtworkForType(MovieSet movieSet, String artworkFolder, String basename, MediaFileType type) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{artworkFolder, basename})) {
            return;
        }
        List<IMovieSetFileNaming> fileNamings = MovieSetArtworkHelper.getAllowedFileNamingsForMediaFileType(type, artworkFolder.contains(basename));
        for (IMovieSetFileNaming fileNaming : fileNamings) {
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                String artworkFileName = fileNaming.getFilename(basename, fileType);
                Path artworkFile = Paths.get(artworkFolder, artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                MediaFile mediaFile = new MediaFile(artworkFile, type);
                TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    private static List<IMovieSetFileNaming> getAllowedFileNamingsForMediaFileType(MediaFileType type, boolean inDedicatedFolder) {
        if (inDedicatedFolder) {
            switch (type) {
                case POSTER: {
                    return List.of(MovieSetPosterNaming.KODI_POSTER, MovieSetPosterNaming.AUTOMATOR_POSTER);
                }
                case FANART: {
                    return List.of(MovieSetFanartNaming.KODI_FANART, MovieSetFanartNaming.AUTOMATOR_FANART);
                }
                case BANNER: {
                    return List.of(MovieSetBannerNaming.KODI_BANNER, MovieSetBannerNaming.AUTOMATOR_BANNER);
                }
                case CLEARART: {
                    return List.of(MovieSetClearartNaming.KODI_CLEARART, MovieSetClearartNaming.AUTOMATOR_CLEARART);
                }
                case CLEARLOGO: 
                case LOGO: {
                    return List.of(MovieSetClearlogoNaming.KODI_CLEARLOGO, MovieSetClearlogoNaming.AUTOMATOR_CLEARLOGO, MovieSetClearlogoNaming.KODI_LOGO, MovieSetClearlogoNaming.AUTOMATOR_LOGO);
                }
                case DISC: {
                    return List.of(MovieSetDiscartNaming.KODI_DISCART, MovieSetDiscartNaming.AUTOMATOR_DISCART, MovieSetDiscartNaming.KODI_DISC, MovieSetDiscartNaming.AUTOMATOR_DISC);
                }
                case THUMB: {
                    return List.of(MovieSetThumbNaming.KODI_THUMB, MovieSetThumbNaming.AUTOMATOR_THUMB, MovieSetThumbNaming.KODI_LANDSCAPE, MovieSetThumbNaming.AUTOMATOR_LANDSCAPE);
                }
            }
        } else {
            switch (type) {
                case POSTER: {
                    return List.of(MovieSetPosterNaming.MOVIESET_POSTER);
                }
                case FANART: {
                    return List.of(MovieSetFanartNaming.MOVIESET_FANART);
                }
                case BANNER: {
                    return List.of(MovieSetBannerNaming.MOVIESET_BANNER);
                }
                case CLEARART: {
                    return List.of(MovieSetClearartNaming.MOVIESET_CLEARART);
                }
                case CLEARLOGO: 
                case LOGO: {
                    return List.of(MovieSetClearlogoNaming.MOVIESET_CLEARLOGO, MovieSetClearlogoNaming.MOVIESET_LOGO);
                }
                case DISC: {
                    return List.of(MovieSetDiscartNaming.MOVIESET_DISCART, MovieSetDiscartNaming.MOVIESET_DISC);
                }
                case THUMB: {
                    return List.of(MovieSetThumbNaming.MOVIESET_THUMB, MovieSetThumbNaming.MOVIESET_LANDSCAPE);
                }
            }
        }
        return Collections.emptyList();
    }

    private static void findArtworkInMovieFolder(MovieSet movieSet, Movie movie) {
        String movieSetName = MovieRenamer.replaceInvalidCharacters(movieSet.getTitle());
        movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
        movieSetName = movieSetName.replaceAll(" +", " ").strip();
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            if (!movieSet.getMediaFiles(type).isEmpty()) continue;
            for (String fileType : SUPPORTED_ARTWORK_FILETYPES) {
                MediaFile mediaFile;
                String artworkFileName = "movieset-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                Path artworkFile = movie.getPathNIO().resolve(artworkFileName);
                if (Files.exists(artworkFile, new LinkOption[0])) {
                    mediaFile = new MediaFile(artworkFile, type);
                    TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                    movieSet.addToMediaFiles(mediaFile);
                }
                artworkFileName = movieSetName + "-" + type.name().toLowerCase(Locale.ROOT) + "." + fileType;
                artworkFile = movie.getPathNIO().resolve(artworkFileName);
                if (!Files.exists(artworkFile, new LinkOption[0])) continue;
                mediaFile = new MediaFile(artworkFile, type);
                TmmTaskManager.getInstance().addUnnamedTask(new MediaFileInformationFetcherTask(mediaFile, movieSet, false));
                movieSet.addToMediaFiles(mediaFile);
            }
        }
    }

    public static void setArtwork(MovieSet movieSet, List<MediaArtwork> artwork, List<MovieSetScraperMetadataConfig> config) {
        if (!ScraperMetadataConfig.containsAnyArtwork(config)) {
            return;
        }
        if (config.contains(MovieSetScraperMetadataConfig.POSTER)) {
            MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        }
        if (config.contains(MovieSetScraperMetadataConfig.FANART)) {
            MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        }
        if (config.contains(MovieSetScraperMetadataConfig.CLEARLOGO)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (config.contains(MovieSetScraperMetadataConfig.CLEARART)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (config.contains(MovieSetScraperMetadataConfig.BANNER)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (config.contains(MovieSetScraperMetadataConfig.THUMB)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (config.contains(MovieSetScraperMetadataConfig.DISCART)) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        movieSet.saveToDb();
        movieSet.writeNFO();
    }

    private static List<MediaArtwork.ImageSizeAndUrl> sortArtworkUrls(List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, int sizeOrder) {
        ArrayList<MediaArtwork> artworkForType = new ArrayList<MediaArtwork>(artwork.stream().filter(art -> art.getType() == type).toList());
        if (artworkForType.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MediaArtwork.ImageSizeAndUrl> sortedArtwork = new ArrayList<MediaArtwork.ImageSizeAndUrl>();
        if (sizeOrder == 0) {
            artworkForType.sort((o1, o2) -> Integer.compare(o2.getBiggestArtwork().getWidth(), o1.getBiggestArtwork().getWidth()));
        }
        List<MediaLanguages> languages = MovieSettings.getInstance().getImageScraperLanguages();
        for (MediaLanguages mediaLanguages : languages) {
            for (MediaArtwork mediaArtwork : artworkForType.stream().filter(art -> art.getLanguage().equals(mediaLanguages.getLanguage())).toList()) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : mediaArtwork.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != sizeOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                    sortedArtwork.add(imageSizeAndUrl);
                }
            }
        }
        if (MovieModuleManager.getInstance().getSettings().isImageScraperOtherResolutions()) {
            int newOrder = 32;
            while (newOrder > 1) {
                newOrder /= 2;
                for (MediaLanguages language : languages) {
                    for (MediaArtwork art3 : artworkForType.stream().filter(art -> art.getLanguage().equals(language.getLanguage())).toList()) {
                        for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art3.getImageSizes()) {
                            if (imageSizeAndUrl.getSizeOrder() != newOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                            sortedArtwork.add(imageSizeAndUrl);
                        }
                    }
                }
            }
        }
        if (MovieModuleManager.getInstance().getSettings().isImageScraperFallback()) {
            for (MediaArtwork mediaArtwork : artworkForType) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : mediaArtwork.getImageSizes()) {
                    if (sortedArtwork.contains(imageSizeAndUrl)) continue;
                    sortedArtwork.add(imageSizeAndUrl);
                }
            }
        }
        return sortedArtwork;
    }

    private static void setBestPoster(MovieSet movieSet, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
        List<MediaArtwork.ImageSizeAndUrl> sortedPosters = MovieSetArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.POSTER, preferredSizeOrder);
        if (!sortedPosters.isEmpty()) {
            MediaArtwork.ImageSizeAndUrl foundPoster = sortedPosters.get(0);
            movieSet.setArtworkUrl(foundPoster.getUrl(), MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(MovieSet movieSet, List<MediaArtwork> artwork) {
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
        MediaArtwork.ImageSizeAndUrl fanartWoText = null;
        if (MovieModuleManager.getInstance().getSettings().isImageScraperPreferFanartWoText()) {
            block0: for (MediaArtwork art : artwork) {
                if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !art.getLanguage().equals("")) continue;
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != preferredSizeOrder) continue;
                    fanartWoText = imageSizeAndUrl;
                    continue block0;
                }
            }
        }
        List<MediaArtwork.ImageSizeAndUrl> sortedFanarts = MovieSetArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder);
        if (fanartWoText != null) {
            sortedFanarts.add(0, fanartWoText);
        }
        if (!sortedFanarts.isEmpty()) {
            MediaArtwork.ImageSizeAndUrl foundfanart = sortedFanarts.get(0);
            movieSet.setArtworkUrl(foundfanart.getUrl(), MediaFileType.FANART);
        }
    }

    private static void setBestArtwork(MovieSet movieSet, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type) {
        int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
        List<MediaArtwork.ImageSizeAndUrl> sortedArtworks = MovieSetArtworkHelper.sortArtworkUrls(artwork, type, preferredSizeOrder);
        if (!sortedArtworks.isEmpty()) {
            MediaArtwork.ImageSizeAndUrl bestArtwork = sortedArtworks.get(0);
            movieSet.setArtworkUrl(bestArtwork.getUrl(), MediaFileType.getMediaFileType(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadArtwork(MovieSet movieSet, MediaFileType type) {
        String url = movieSet.getArtworkUrl(type);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        try {
            MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type);
            TmmTaskManager.getInstance().addImageDownloadTask(task);
        }
        finally {
            if (url.startsWith("file:")) {
                movieSet.removeArtworkUrl(type);
            }
        }
    }

    public static void writeImagesToMovieFolder(MovieSet movieSet, List<Movie> movies) {
        for (MediaFileType type : SUPPORTED_ARTWORK_TYPES) {
            List<IMovieSetFileNaming> fileNamings = MovieSetArtworkHelper.getFileNamingsForMediaFileType(type);
            for (IMovieSetFileNaming fileNaming : fileNamings) {
                String url;
                if (fileNaming.getFolderLocation() != IMovieSetFileNaming.Location.MOVIE_FOLDER || StringUtils.isBlank((CharSequence)(url = movieSet.getArtworkUrl(type)))) continue;
                MovieSetImageFetcherTask task = new MovieSetImageFetcherTask(movieSet, url, type, Collections.singletonList(fileNaming), movies);
                TmmTaskManager.getInstance().addImageDownloadTask(task);
            }
        }
    }

    public static void cleanMovieSetArtworkInMovieFolder(Movie movie) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(movie.getPathNIO());){
            for (Path entry : stream) {
                Matcher matcher = MediaFileHelper.MOVIESET_ARTWORK_PATTERN.matcher(entry.getFileName().toString());
                if (!matcher.find()) continue;
                Utils.deleteFileSafely(entry);
            }
        }
        catch (Exception e) {
            LOGGER.error("Remove movie set artwork for '{}' did not work - '{}'", (Object)movie.getTitle(), (Object)e.getMessage());
        }
    }

    public static void removeMovieSetArtwork(MovieSet movieSet) {
        List<Path> subfolders;
        for (MediaFile mediaFile : movieSet.getMediaFiles()) {
            if (!mediaFile.isGraphic()) continue;
            Utils.deleteFileSafely(mediaFile.getFile());
        }
        if (StringUtils.isBlank((CharSequence)MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder())) {
            return;
        }
        Path movieSetArtworkFolder = Paths.get(MovieModuleManager.getInstance().getSettings().getMovieSetDataFolder(), new String[0]);
        try (Stream<Path> stream = Files.walk(movieSetArtworkFolder, 1, new FileVisitOption[0]);){
            subfolders = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList();
        }
        catch (Exception e) {
            LOGGER.warn("Could not clean movie set artwork subfolders '{}' - '{}'", (Object)movieSetArtworkFolder, (Object)e.getMessage());
            return;
        }
        for (Path path : subfolders) {
            if (path.equals(movieSetArtworkFolder)) continue;
            try {
                Utils.deleteEmptyDirectoryRecursive(path);
            }
            catch (Exception e) {
                LOGGER.warn("Could not clean empty subfolder '{}' - '{}'", (Object)path, (Object)e.getMessage());
            }
        }
    }

    public static boolean hasMissingArtwork(MovieSet movieSet) {
        if (!MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (!MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        return !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && movieSet.getMediaFiles(MediaFileType.THUMB).isEmpty();
    }

    public static void getMissingArtwork(MovieSet movieSet, List<MediaArtwork> artwork) {
        if (movieSet.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            MovieSetArtworkHelper.setBestPoster(movieSet, artwork);
        }
        if (movieSet.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            MovieSetArtworkHelper.setBestFanart(movieSet, artwork);
        }
        if (movieSet.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO);
        }
        if (movieSet.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.CLEARART);
        }
        if (movieSet.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.BANNER);
        }
        if (movieSet.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.THUMB);
        }
        if (movieSet.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            MovieSetArtworkHelper.setBestArtwork(movieSet, artwork, MediaArtwork.MediaArtworkType.DISC);
        }
        movieSet.saveToDb();
    }

    private static List<IMovieSetFileNaming> getFileNamingsForMediaFileType(MediaFileType type) {
        ArrayList<IMovieSetFileNaming> fileNamings = new ArrayList<IMovieSetFileNaming>(0);
        switch (type) {
            case FANART: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetFanartFilenames());
                break;
            }
            case POSTER: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetPosterFilenames());
                break;
            }
            case CLEARLOGO: 
            case LOGO: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetClearlogoFilenames());
                break;
            }
            case BANNER: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetBannerFilenames());
                break;
            }
            case CLEARART: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetClearartFilenames());
                break;
            }
            case THUMB: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetThumbFilenames());
                break;
            }
            case DISC: {
                fileNamings.addAll(MovieModuleManager.getInstance().getSettings().getMovieSetDiscartFilenames());
                break;
            }
        }
        return fileNamings;
    }

    public static String getMovieSetTitleForStorage(MovieSet movieSet) {
        return MovieSetArtworkHelper.getMovieSetTitleForStorage(movieSet, MovieModuleManager.getInstance().getSettings().getMovieSetTitleCharacterReplacement());
    }

    public static String getMovieSetTitleForStorage(MovieSet movieSet, String replacement) {
        String result = movieSet.getTitle();
        result = result.replace("/", replacement);
        result = result.replace("\\", replacement);
        result = result.replace("?", replacement);
        result = result.replace(":", replacement);
        result = result.replace("*", replacement);
        result = result.replace("\"", replacement);
        result = result.replace("<", replacement);
        result = result.replace(">", replacement);
        result = result.replace("|", replacement);
        result = result.replaceAll(" +", " ").strip();
        return result;
    }

    private static class MovieSetImageFetcherTask
    implements Runnable {
        private final MovieSet movieSet;
        private final String urlToArtwork;
        private final MediaFileType type;
        private final List<IMovieSetFileNaming> fileNamings = new ArrayList<IMovieSetFileNaming>();
        private final List<Movie> movies = new ArrayList<Movie>();
        private final List<MediaFile> writtenArtworkFiles = new ArrayList<MediaFile>();

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type) {
            this(movieSet, url, type, movieSet.getMovies());
        }

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type, List<Movie> movies) {
            this(movieSet, url, type, MovieSetArtworkHelper.getFileNamingsForMediaFileType(type), movies);
        }

        private MovieSetImageFetcherTask(MovieSet movieSet, String url, MediaFileType type, List<IMovieSetFileNaming> fileNamings, List<Movie> movies) {
            this.movieSet = movieSet;
            this.urlToArtwork = url;
            this.type = type;
            this.fileNamings.addAll(fileNamings);
            this.movies.addAll(movies);
        }

        @Override
        public void run() {
            try {
                Url url = new Url(this.urlToArtwork);
                try (InputStream is = url.getInputStream();){
                    byte[] bytes = IOUtils.toByteArray((InputStream)is);
                    String extension = Utils.getArtworkExtensionFromContentType(url.getHeader("content-type"));
                    if (StringUtils.isBlank((CharSequence)extension)) {
                        extension = Utils.getArtworkExtensionFromUrl(this.urlToArtwork);
                    }
                    List<MediaFile> oldMediaFiles = this.movieSet.getMediaFiles(this.type);
                    this.movieSet.removeAllMediaFiles(this.type);
                    for (MediaFile mediaFile : oldMediaFiles) {
                        ImageCache.invalidateCachedImage(mediaFile.getFile());
                        Utils.deleteFileSafely(mediaFile.getFile());
                    }
                    if (!this.fileNamings.isEmpty()) {
                        this.writeImageToArtworkFolder(bytes, extension);
                        this.writeImageToMovieFolders(bytes, extension);
                    } else {
                        this.writeImageToCacheFolder(bytes);
                    }
                    this.movieSet.addToMediaFiles(this.writtenArtworkFiles);
                    this.movieSet.saveToDb();
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Could not fetch image '{}' - '{}'", (Object)this.urlToArtwork, (Object)e.getMessage());
            }
        }

        private void writeImageToArtworkFolder(byte[] bytes, String extension) {
            List<Path> paths = MovieSetArtworkHelper.createArtworkPathsInArtworkFolder(this.movieSet, this.fileNamings, extension);
            for (Path path : paths) {
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    try {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not create directory '{}' - '{}'", (Object)path.getParent(), (Object)e.getMessage());
                    }
                }
                try {
                    this.writeImage(bytes, path);
                    MediaFile artwork = new MediaFile(path, this.type);
                    artwork.gatherMediaInformation();
                    this.writtenArtworkFiles.add(artwork);
                    ImageCache.invalidateCachedImage(artwork);
                    ImageCache.cacheImageSilently(artwork);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not write file '{}' - '{}'", (Object)path, (Object)e.getMessage());
                }
            }
        }

        private void writeImageToMovieFolders(byte[] bytes, String extension) {
            if (this.movies.isEmpty()) {
                return;
            }
            String movieSetName = MovieRenamer.replaceInvalidCharacters(this.movieSet.getTitle());
            movieSetName = MovieRenamer.replacePathSeparators(movieSetName);
            movieSetName = movieSetName.replaceAll(" +", " ").strip();
            List<IMovieSetFileNaming> movieFileNamings = this.fileNamings.stream().filter(fileNaming -> fileNaming.getFolderLocation() == IMovieSetFileNaming.Location.MOVIE_FOLDER).toList();
            for (IMovieSetFileNaming fileNaming2 : movieFileNamings) {
                String filename = fileNaming2.getFilename(movieSetName, extension);
                for (Movie movie : this.movies) {
                    try {
                        if (movie.isMultiMovieDir()) continue;
                        Path imageFile = movie.getPathNIO().resolve(filename);
                        this.writeImage(bytes, imageFile);
                        MediaFile artwork = new MediaFile(imageFile, this.type);
                        artwork.gatherMediaInformation();
                        this.writtenArtworkFiles.add(artwork);
                        ImageCache.invalidateCachedImage(artwork);
                        ImageCache.cacheImageSilently(artwork);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not write movie set artwork files", (Throwable)e);
                    }
                }
            }
        }

        private void writeImageToCacheFolder(byte[] bytes) {
            String filename = ImageCache.getMD5WithSubfolder(this.urlToArtwork);
            try {
                this.writeImage(bytes, ImageCache.getCacheDir().resolve(filename + ".jpg"));
            }
            catch (Exception e) {
                LOGGER.warn("Error writing artwork file '{}' - '{}'", (Object)filename, (Object)e.getMessage());
            }
        }

        private void writeImage(byte[] bytes, Path pathAndFilename) throws IOException {
            try (FileOutputStream outputStream = new FileOutputStream(pathAndFilename.toFile());
                 ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
                IOUtils.copy((InputStream)is, (OutputStream)outputStream);
                outputStream.flush();
                try {
                    outputStream.getFD().sync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

