/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import org.tinymediamanager.core.TmmResourceBundle;

public enum MediaAiredStatus {
    UNKNOWN("Unknown", new String[]{""}),
    CONTINUING("Continuing", new String[]{"Continuing", "returning series"}),
    ENDED("Ended", new String[]{"Ended"}),
    CANCELED("Canceled", new String[]{"Canceled"});

    private final String name;
    private final String[] possibleNotations;

    private MediaAiredStatus(String name, String[] possibleNotations) {
        this.name = name;
        this.possibleNotations = possibleNotations;
    }

    public static MediaAiredStatus findAiredStatus(String text) {
        for (MediaAiredStatus status : MediaAiredStatus.values()) {
            for (String notation : status.possibleNotations) {
                if (!notation.equalsIgnoreCase(text)) continue;
                return status;
            }
        }
        return UNKNOWN;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return this.toString();
    }

    public String toString() {
        try {
            return TmmResourceBundle.getString("MediaAiredStatus." + this.name());
        }
        catch (Exception ignored) {
            return this.name;
        }
    }
}

