/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.search.query;

import com.github.kiulian.downloader.jackson.JSONObject;
import com.github.kiulian.downloader.model.Utils;
import com.github.kiulian.downloader.model.search.query.QueryElement;
import com.github.kiulian.downloader.model.search.query.QueryElementType;
import com.github.kiulian.downloader.model.search.query.Searchable;

public class QuerySuggestion
extends Searchable
implements QueryElement {
    private final String title;

    public QuerySuggestion(JSONObject jSONObject) {
        super(jSONObject);
        this.title = Utils.parseRuns(jSONObject.getJSONObject("didYouMean"));
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public QueryElementType type() {
        return QueryElementType.SUGGESTION;
    }

    @Override
    protected String extractQuery(JSONObject jSONObject) {
        return Utils.parseRuns(jSONObject.getJSONObject("correctedQuery"));
    }

    @Override
    protected String extractSearchPath(JSONObject jSONObject) {
        return jSONObject.getJSONObject("correctedQueryEndpoint").getJSONObject("commandMetadata").getJSONObject("webCommandMetadata").getString("url");
    }
}

