/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.builder;

import java.util.Arrays;
import org.mp4parser.muxer.Track;
import org.mp4parser.muxer.builder.DefaultMp4Builder;
import org.mp4parser.muxer.builder.Fragmenter;
import org.mp4parser.tools.Mp4Arrays;

public class DefaultFragmenterImpl
implements Fragmenter {
    private double fragmentLength = 2.0;

    public DefaultFragmenterImpl(double fragmentLength) {
        this.fragmentLength = fragmentLength;
    }

    public static void main(String[] args) {
        DefaultMp4Builder b = new DefaultMp4Builder();
        b.setFragmenter(new DefaultFragmenterImpl(0.5));
    }

    @Override
    public long[] sampleNumbers(Track track) {
        long[] segmentStartSamples = new long[]{1L};
        long[] sampleDurations = track.getSampleDurations();
        long[] syncSamples = track.getSyncSamples();
        long timescale = track.getTrackMetaData().getTimescale();
        double time = 0.0;
        for (int i = 0; i < sampleDurations.length; ++i) {
            if (!((time += (double)sampleDurations[i] / (double)timescale) >= this.fragmentLength) || syncSamples != null && Arrays.binarySearch(syncSamples, (long)(i + 1)) < 0) continue;
            if (i > 0) {
                segmentStartSamples = Mp4Arrays.copyOfAndAppend((long[])segmentStartSamples, (long[])new long[]{i + 1});
            }
            time = 0.0;
        }
        return segmentStartSamples;
    }
}

