/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.PersonWithRole;
import org.jupnp.support.model.ProtocolInfo;
import org.jupnp.support.model.Res;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.thirdparty.upnp.MimeTypes;
import org.tinymediamanager.thirdparty.upnp.Upnp;

class Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metadata.class);

    private Metadata() {
        throw new IllegalAccessError();
    }

    public static org.jupnp.support.model.item.Movie getUpnpMovie(Movie tmmMovie, boolean full) {
        org.jupnp.support.model.item.Movie m = new org.jupnp.support.model.item.Movie();
        try {
            m.setId(tmmMovie.getDbId().toString());
            m.setParentID("1");
            if (tmmMovie.getYear() > 0) {
                m.addProperty((DIDLObject.Property)new DIDLObject.Property.DC.DATE(tmmMovie.getReleaseDateFormatted()));
            }
            m.setTitle(tmmMovie.getTitle());
            for (MediaFile mediaFile : tmmMovie.getMediaFiles(MediaFileType.VIDEO)) {
                String string = tmmMovie.getPathNIO().relativize(mediaFile.getFileAsPath()).toString().replaceAll("\\\\", "/");
                String url = "http://" + Upnp.getInstance().getIpAddress() + ":" + Upnp.getInstance().getPort() + "/upnp/movies/" + tmmMovie.getDbId().toString() + "/" + URLEncoder.encode(string, StandardCharsets.UTF_8);
                Res r = Metadata.createRes(url, mediaFile);
                m.addResource(r);
            }
            if (full) {
                ArrayList arrayList;
                m.setDescription(tmmMovie.getPlot());
                m.setLanguage(tmmMovie.getSpokenLanguages());
                m.setRating(String.valueOf(tmmMovie.getRating()));
                ArrayList<String> genres = new ArrayList<String>();
                for (MediaGenres mediaGenres : tmmMovie.getGenres()) {
                    genres.add(mediaGenres.getLocalizedName());
                }
                if (!genres.isEmpty()) {
                    String[] stringArray = genres.toArray(new String[genres.size()]);
                    m.setGenres(stringArray);
                }
                ArrayList<PersonWithRole> arrayList2 = new ArrayList<PersonWithRole>();
                for (org.tinymediamanager.core.entities.Person a : tmmMovie.getActors()) {
                    arrayList2.add(new PersonWithRole(a.getName(), a.getRole()));
                }
                if (!arrayList2.isEmpty()) {
                    PersonWithRole[] personWithRoleArray = arrayList2.toArray(new PersonWithRole[arrayList2.size()]);
                    m.setActors(personWithRoleArray);
                }
                if (!(arrayList = new ArrayList()).isEmpty()) {
                    PersonWithRole[] personWithRoleArray = arrayList.toArray(new PersonWithRole[arrayList.size()]);
                    m.setProducers((Person[])personWithRoleArray);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("UPnP: Error getting movie '{}'", (Object)e.getMessage());
        }
        return m;
    }

    public static org.jupnp.support.model.item.Movie getUpnpTvShowEpisode(TvShow show, TvShowEpisode ep, boolean full) {
        org.jupnp.support.model.item.Movie m = new org.jupnp.support.model.item.Movie();
        try {
            m.setId("2/" + show.getDbId().toString() + "/" + ep.getSeason() + "/" + ep.getEpisode());
            m.setParentID("2/" + show.getDbId().toString() + "/" + ep.getSeason());
            if (ep.getYear() > 0) {
                m.addProperty((DIDLObject.Property)new DIDLObject.Property.DC.DATE(ep.getFirstAiredFormatted()));
            }
            m.setTitle("S" + Metadata.lz(ep.getSeason()) + "E" + Metadata.lz(ep.getEpisode()) + " " + ep.getTitle());
            for (MediaFile mediaFile : ep.getMediaFiles(MediaFileType.VIDEO)) {
                String string = show.getPathNIO().relativize(mediaFile.getFileAsPath()).toString().replaceAll("\\\\", "/");
                String url = "http://" + Upnp.getInstance().getIpAddress() + ":" + Upnp.getInstance().getPort() + "/upnp/tvshows/" + show.getDbId().toString() + "/" + URLEncoder.encode(string, StandardCharsets.UTF_8);
                Res r = Metadata.createRes(url, mediaFile);
                m.addResource(r);
            }
            if (full) {
                m.setDescription(ep.getPlot());
                m.setRating(String.valueOf(ep.getRating()));
                ArrayList<String> genres = new ArrayList<String>();
                for (MediaGenres mediaGenres : show.getGenres()) {
                    genres.add(mediaGenres.getLocalizedName());
                }
                if (!genres.isEmpty()) {
                    String[] stringArray = genres.toArray(new String[genres.size()]);
                    m.setGenres(stringArray);
                }
                ArrayList<PersonWithRole> arrayList = new ArrayList<PersonWithRole>();
                for (org.tinymediamanager.core.entities.Person a : ep.getActors()) {
                    arrayList.add(new PersonWithRole(a.getName(), a.getRole()));
                }
                if (!arrayList.isEmpty()) {
                    PersonWithRole[] personWithRoleArray = arrayList.toArray(new PersonWithRole[arrayList.size()]);
                    m.setActors(personWithRoleArray);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("UPnP: Error getting episode - '{}'", (Object)e.getMessage());
        }
        return m;
    }

    private static Res createRes(String url, MediaFile mf) {
        Res r = new Res();
        r.setValue(url);
        r.setProtocolInfo(new ProtocolInfo(MimeTypes.getMimeType(mf.getExtension())));
        if (mf.getFilesize() > 0L) {
            r.setSize(Long.valueOf(mf.getFilesize()));
        }
        if (mf.getVideoWidth() > 0 && mf.getVideoHeight() > 0) {
            r.setResolution(mf.getVideoWidth(), mf.getVideoHeight());
        }
        if (mf.getVideoBitRate() > 0) {
            r.setBitrate(Long.valueOf(mf.getVideoBitRate()));
        }
        if (mf.getAudioChannelCount() > 0) {
            r.setNrAudioChannels(Long.valueOf(mf.getAudioChannelCount()));
        }
        if (mf.getDuration() > 0) {
            r.setDuration(mf.getDurationHHMMSS());
        }
        return r;
    }

    private static String lz(int num) {
        return String.format("%02d", num);
    }
}

