/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Movie;
import com.uwetrottmann.trakt5.entities.MovieTranslation;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.enums.Extended;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaIdProvider;
import org.tinymediamanager.scraper.interfaces.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IMovieMetadataProvider;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMovieArtworkProvider;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class TraktMovieMetadataProvider
extends TraktMetadataProvider
implements IMovieMetadataProvider,
IMovieImdbMetadataProvider,
IRatingProvider,
IMediaIdProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktMovieMetadataProvider.class);

    @Override
    protected String getSubId() {
        return "movie";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(MovieSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search() - {}", (Object)options);
        this.initAPI();
        String searchString = "";
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = options.getSearchQuery();
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        List searchResults = null;
        String id = options.getIdAsString("trakt");
        if (id != null) {
            try {
                MediaMetadata md = this.getMetadata(options);
                MediaSearchResult msr = new MediaSearchResult(id, options.getMediaType());
                msr.mergeFrom(md);
                msr.setScore(1.0f);
                results.add(msr);
                return results;
            }
            catch (Exception e) {
                LOGGER.debug("Problem scraping for {} - {}", (Object)searchString, (Object)e.getMessage());
            }
        }
        try {
            searchResults = (List)this.executeCall(this.api.search().textQueryMovie(searchString, null, null, null, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)));
        }
        catch (Exception e) {
            LOGGER.debug("Problem scraping for {} - {}", (Object)searchString, (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.debug("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, result);
            if (StringUtils.isNotBlank((CharSequence)options.getImdbId()) && options.getImdbId().equals(m.getIMDBId()) || String.valueOf(options.getTmdbId()).equals(m.getId()) || id != null && id.equals(m.getId())) {
                LOGGER.debug("perfect match by ID - set score to 1");
                m.setScore(1.0f);
            } else {
                m.calculateScore(options);
            }
            results.add(m);
        }
        return results;
    }

    @Override
    public MediaMetadata getMetadata(MovieSearchAndScrapeOptions options) throws ScrapeException {
        TmdbMovieArtworkProvider tmdb;
        MovieTranslation trans;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        String id = options.getIdAsString(this.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.debug("no id available");
            throw new MissingIdException("imdb", this.getId());
        }
        LOGGER.debug("Trakt.tv: getMetadata: id = {}", (Object)id);
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        Movie movie = null;
        Credits credits = null;
        try {
            movie = (Movie)this.executeCall(this.api.movies().summary(id, Extended.FULL));
            if (!"en".equals(lang)) {
                translations = (List)this.api.movies().translation(id, lang).execute().body();
            }
            credits = (Credits)this.api.movies().people(id).execute().body();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (movie == null) {
            LOGGER.debug("nothing found");
            throw new NothingFoundException();
        }
        MovieTranslation movieTranslation = trans = translations == null || translations.isEmpty() ? null : (MovieTranslation)translations.get(0);
        if (trans != null) {
            md.setTitle(StringUtils.isBlank((CharSequence)trans.title) ? movie.title : trans.title);
            md.setTagline(StringUtils.isBlank((CharSequence)trans.tagline) ? movie.tagline : trans.tagline);
            md.setPlot(StringUtils.isBlank((CharSequence)trans.overview) ? movie.overview : trans.overview);
        } else {
            md.setTitle(movie.title);
            md.setTagline(movie.tagline);
            md.setPlot(movie.overview);
        }
        md.setYear(movie.year);
        md.setRuntime(movie.runtime);
        md.addCertification(MediaCertification.findCertification(movie.certification));
        md.setReleaseDate(TraktUtils.toDate(movie.released));
        if (movie.rating != null && movie.votes != null) {
            try {
                MediaRating rating = new MediaRating("trakt");
                rating.setRating((double)Math.round(movie.rating * 10.0) / 10.0);
                rating.setVotes(movie.votes);
                rating.setMaxValue(10);
                md.addRating(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
        }
        if (movie.ids != null) {
            md.setId(this.getId(), movie.ids.trakt);
            if (movie.ids.tmdb != null && movie.ids.tmdb > 0) {
                md.setId("tmdb", movie.ids.tmdb);
            }
            if (MediaIdUtil.isValidImdbId(movie.ids.imdb)) {
                md.setId("imdb", movie.ids.imdb);
            }
        }
        for (String genreAsString : ListUtils.nullSafe(movie.genres)) {
            md.addGenre(MediaGenres.getGenre(genreAsString));
        }
        if (credits != null) {
            for (CastMember cast : ListUtils.nullSafe(credits.cast)) {
                md.addCastMember(TraktUtils.toTmmCast(cast, Person.Type.ACTOR));
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.directing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.DIRECTOR));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.production)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.PRODUCER));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.writing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.WRITER));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.sound)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.COMPOSER));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.camera)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.CAMERA));
                }
            }
        }
        if ((tmdb = new TmdbMovieArtworkProvider()).isActive() && (MediaIdUtil.isValidImdbId(movie.ids.imdb) || movie.ids.tmdb > 0)) {
            try {
                ArtworkSearchAndScrapeOptions tmdbOptions = new ArtworkSearchAndScrapeOptions(options.getMediaType());
                tmdbOptions.setImdbId(movie.ids.imdb);
                tmdbOptions.setTmdbId(movie.ids.tmdb);
                tmdbOptions.setLanguage(options.getLanguage());
                tmdbOptions.setArtworkType(MediaArtwork.MediaArtworkType.POSTER);
                List<MediaArtwork> artworks = tmdb.getArtwork(tmdbOptions);
                if (ListUtils.isNotEmpty(artworks)) {
                    md.addMediaArt(artworks.get(0));
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get artwork from tmdb - {}", (Object)e.getMessage());
            }
        }
        return md;
    }

    @Override
    public List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        Movie movie;
        if (mediaType != MediaType.MOVIE) {
            return Collections.emptyList();
        }
        LOGGER.debug("getRatings(): {}", ids);
        this.initAPI();
        String id = MediaIdUtil.getIdAsString(ids, this.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = MediaIdUtil.getIdAsString(ids, "imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.debug("no id available");
            throw new MissingIdException("imdb", this.getId());
        }
        LOGGER.debug("Trakt.tv: getMetadata: id = {}", (Object)id);
        try {
            movie = (Movie)this.executeCall(this.api.movies().summary(id, Extended.FULL));
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (movie == null) {
            LOGGER.debug("nothing found");
            throw new NothingFoundException();
        }
        if (movie.rating != null && movie.votes != null) {
            try {
                MediaRating rating = new MediaRating("trakt");
                rating.setRating((double)Math.round(movie.rating * 10.0) / 10.0);
                rating.setVotes(movie.votes);
                rating.setMaxValue(10);
                return Collections.singletonList(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getMediaIds(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        if (mediaType != MediaType.MOVIE) {
            return Collections.emptyMap();
        }
        LOGGER.debug("getMediaIds: {}", ids);
        this.initAPI();
        String id = MediaIdUtil.getIdAsString(ids, this.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = MediaIdUtil.getIdAsString(ids, "imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.debug("neither trakt.tv nor imdb available");
            throw new MissingIdException("imdb", this.getId());
        }
        Movie movie = null;
        try {
            movie = (Movie)this.executeCall(this.api.movies().summary(id, Extended.FULL));
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (movie == null) {
            LOGGER.debug("nothing found");
            throw new NothingFoundException();
        }
        HashMap<String, Object> scrapedIds = new HashMap<String, Object>();
        if (movie.ids != null) {
            scrapedIds.put(this.getId(), movie.ids.trakt);
            if (movie.ids.tmdb != null && movie.ids.tmdb > 0) {
                scrapedIds.put("tmdb", movie.ids.tmdb);
            }
            if (MediaIdUtil.isValidImdbId(movie.ids.imdb)) {
                scrapedIds.put("imdb", movie.ids.imdb);
            }
        }
        return scrapedIds;
    }
}

