/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.bdjo;

import jakarta.xml.bind.JAXBException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.script.ScriptException;
import org.tinymediamanager.library.bluray.bdjo.BDJO;
import org.tinymediamanager.library.bluray.bdjo.BDJOReader;
import org.tinymediamanager.library.bluray.bdjo.BDJOWriter;

public final class Converter {
    private Converter() {
    }

    public static void bdjoToFX(InputStream inputStream, Writer writer) throws IOException {
        BDJO bDJO = BDJOReader.readBDJO(inputStream);
        BDJOWriter.writeFX(bDJO, writer);
    }

    public static void bdjoToXML(InputStream inputStream, Writer writer) throws IOException, JAXBException {
        BDJO bDJO = BDJOReader.readBDJO(inputStream);
        BDJOWriter.writeXML(bDJO, writer);
    }

    public static void xmlToFX(Reader reader, Writer writer) throws IOException, JAXBException {
        BDJO bDJO = BDJOReader.readXML(reader);
        BDJOWriter.writeFX(bDJO, writer);
    }

    public static void xmlToBDJO(Reader reader, OutputStream outputStream) throws IOException, JAXBException {
        BDJO bDJO = BDJOReader.readXML(reader);
        BDJOWriter.writeBDJO(bDJO, outputStream);
    }

    public static void fxToXML(Reader reader, Writer writer) throws ScriptException, JAXBException {
        BDJO bDJO = BDJOReader.readFX(reader);
        BDJOWriter.writeXML(bDJO, writer);
    }

    public static void fxToBDJO(Reader reader, OutputStream outputStream) throws IOException, ScriptException {
        BDJO bDJO = BDJOReader.readFX(reader);
        BDJOWriter.writeBDJO(bDJO, outputStream);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.printf("Usage: %s <file-1> <file-2>", Converter.class.getName());
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (string.endsWith(".fx")) {
            if (string2.endsWith(".xml")) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
                Converter.fxToXML(bufferedReader, bufferedWriter);
            } else if (string2.endsWith(".bdjo")) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                Converter.fxToBDJO(bufferedReader, bufferedOutputStream);
            } else {
                System.err.println("not supported yet!");
            }
        } else if (string.endsWith(".xml")) {
            if (string2.endsWith(".fx")) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
                Converter.xmlToFX(bufferedReader, bufferedWriter);
            } else if (string2.endsWith(".bdjo")) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                Converter.xmlToBDJO(bufferedReader, bufferedOutputStream);
            } else {
                System.err.println("not supported yet!");
            }
        } else if (string.endsWith(".bdjo")) {
            if (string2.endsWith(".fx")) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
                Converter.bdjoToFX(bufferedInputStream, bufferedWriter);
            } else if (string2.endsWith(".xml")) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
                Converter.bdjoToXML(bufferedInputStream, bufferedWriter);
            } else {
                System.err.println("not supported yet!");
            }
        } else {
            System.err.println("Unsupported input format");
            System.exit(1);
        }
    }
}

