/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class TmmTaskManager
implements TmmTaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmTaskManager.class);
    public final AtomicLong GLOB_THRD_CNT = new AtomicLong(1L);
    private static final TmmTaskManager instance = new TmmTaskManager();
    private final Set<TmmTaskListener> taskListener = new CopyOnWriteArraySet<TmmTaskListener>();
    private final Set<TmmTaskHandle> runningTasks = new CopyOnWriteArraySet<TmmTaskHandle>();
    private ThreadPoolExecutor imageDownloadExecutor;
    private ThreadPoolExecutor imageCacheExecutor;
    private ThreadPoolExecutor unnamedTaskExecutor;
    private ThreadPoolExecutor downloadExecutor;
    private final ThreadPoolExecutor mainTaskExecutor;
    private final ExecutorService uiTaskExecutor;
    private final TmmTaskHandle imageDownloadHandle;
    private final TmmTaskHandle imageCacheHandle;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private boolean isShutdown = false;

    private TmmTaskManager() {
        this.mainTaskExecutor = this.createMainTaskQueue();
        this.uiTaskExecutor = Executors.newSingleThreadExecutor();
        this.imageDownloadHandle = new ImageDownloadTaskHandle();
        this.imageCacheHandle = new ImageCacheTaskHandle();
        Settings.getInstance().addPropertyChangeListener("maximumDownloadThreads", e -> {
            if (this.downloadExecutor != null) {
                if (this.downloadExecutor.getMaximumPoolSize() < Settings.getInstance().getMaximumDownloadThreads()) {
                    this.downloadExecutor.setMaximumPoolSize(Settings.getInstance().getMaximumDownloadThreads());
                    this.downloadExecutor.setCorePoolSize(Settings.getInstance().getMaximumDownloadThreads());
                } else {
                    this.downloadExecutor.setCorePoolSize(Settings.getInstance().getMaximumDownloadThreads());
                    this.downloadExecutor.setMaximumPoolSize(Settings.getInstance().getMaximumDownloadThreads());
                }
                this.downloadExecutor.prestartAllCoreThreads();
            }
        });
    }

    public static TmmTaskManager getInstance() {
        return instance;
    }

    public void addTaskListener(TmmTaskListener listener) {
        this.taskListener.add(listener);
    }

    public void removeTaskListener(TmmTaskListener listener) {
        this.taskListener.remove(listener);
    }

    private ThreadPoolExecutor createImageDownloadExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(3, 3, 2L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new TmmThreadPool.TmmThreadFactory("image-download-task")){

            @Override
            protected void beforeExecute(Thread d, Runnable r) {
                super.beforeExecute(d, r);
                if (TmmTaskManager.this.imageDownloadHandle != null) {
                    TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageDownloadHandle);
                }
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (TmmTaskManager.this.imageDownloadHandle != null) {
                    TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageDownloadHandle);
                }
            }
        };
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private ThreadPoolExecutor createImageCacheExecutor() {
        int threadCount = Runtime.getRuntime().availableProcessors() / 2;
        if (threadCount < 2) {
            threadCount = 2;
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 2L, TimeUnit.SECONDS, new LinkedBlockingQueue(), new TmmThreadPool.TmmThreadFactory("image-cache-task")){

            @Override
            protected void beforeExecute(Thread d, Runnable r) {
                super.beforeExecute(d, r);
                if (TmmTaskManager.this.imageCacheHandle != null) {
                    TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageCacheHandle);
                }
            }

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (TmmTaskManager.this.imageCacheHandle != null) {
                    TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageCacheHandle);
                }
            }
        };
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private ThreadPoolExecutor createUnnamedTaskExecutor() {
        int threadCount = Runtime.getRuntime().availableProcessors() / 2;
        if (threadCount < 2) {
            threadCount = 2;
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(threadCount, threadCount, 2L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new TmmThreadPool.TmmThreadFactory("unnamed-task"));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public void addImageDownloadTask(Runnable task) {
        if (this.isShutdown) {
            return;
        }
        if (this.imageDownloadExecutor == null || this.imageDownloadExecutor.isShutdown()) {
            this.imageDownloadExecutor = this.createImageDownloadExecutor();
        }
        this.imageDownloadExecutor.execute(task);
    }

    public void addImageCacheTask(Runnable task) {
        if (this.isShutdown) {
            return;
        }
        if (this.imageCacheExecutor == null || this.imageCacheExecutor.isShutdown()) {
            this.imageCacheExecutor = this.createImageCacheExecutor();
        }
        this.imageCacheExecutor.execute(task);
    }

    public void addUnnamedTask(TmmTask task) {
        if (this.isShutdown) {
            return;
        }
        if (this.unnamedTaskExecutor == null || this.unnamedTaskExecutor.isShutdown()) {
            this.unnamedTaskExecutor = this.createUnnamedTaskExecutor();
        }
        task.setState(TmmTaskHandle.TaskState.QUEUED);
        task.addListener(this);
        this.processTaskEvent(task);
        this.unnamedTaskExecutor.execute(task);
    }

    public void addUnnamedTask(Runnable task) {
        if (this.isShutdown) {
            return;
        }
        if (this.unnamedTaskExecutor == null || this.unnamedTaskExecutor.isShutdown()) {
            this.unnamedTaskExecutor = this.createUnnamedTaskExecutor();
        }
        this.unnamedTaskExecutor.execute(task);
    }

    public void addDownloadTask(TmmTask task) {
        if (this.isShutdown) {
            return;
        }
        if (this.downloadExecutor == null) {
            this.downloadExecutor = new ThreadPoolExecutor(Settings.getInstance().getMaximumDownloadThreads(), Settings.getInstance().getMaximumDownloadThreads(), 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new TmmThreadPool.TmmThreadFactory("download-task"));
            this.downloadExecutor.allowCoreThreadTimeOut(true);
        }
        task.setState(TmmTaskHandle.TaskState.QUEUED);
        task.addListener(this);
        this.processTaskEvent(task);
        this.downloadExecutor.execute(task);
    }

    public void cancelImageDownloads() {
        if (this.imageDownloadExecutor != null) {
            this.imageDownloadExecutor.shutdownNow();
        }
    }

    public void cancelImageCache() {
        if (this.imageCacheExecutor != null) {
            this.imageCacheExecutor.shutdownNow();
        }
    }

    public void addMainTask(TmmThreadPool newTask) {
        if (this.isShutdown) {
            return;
        }
        newTask.setState(TmmTaskHandle.TaskState.QUEUED);
        newTask.addListener(this);
        this.processTaskEvent(newTask);
        this.mainTaskExecutor.execute(newTask);
    }

    public void addUiTask(Runnable runnable) {
        this.uiTaskExecutor.submit(runnable);
    }

    private ThreadPoolExecutor createMainTaskQueue() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new TmmThreadPool.TmmThreadFactory("main-task"));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public void shutdown() {
        LOGGER.info("Sending shutdown signal to running tasks");
        this.isShutdown = true;
        if (this.imageDownloadExecutor != null) {
            this.imageDownloadExecutor.shutdown();
        }
        if (this.imageCacheExecutor != null) {
            this.imageCacheExecutor.shutdown();
        }
        if (this.unnamedTaskExecutor != null) {
            this.unnamedTaskExecutor.shutdown();
        }
        if (this.downloadExecutor != null) {
            this.downloadExecutor.shutdown();
        }
        this.mainTaskExecutor.shutdown();
        this.scheduler.shutdown();
        for (TmmTaskHandle task : this.runningTasks) {
            task.cancel();
        }
    }

    public void shutdownNow() {
        LOGGER.info("Stopping task executors");
        this.isShutdown = true;
        boolean stopped = true;
        try {
            if (this.imageDownloadExecutor != null && !this.imageDownloadExecutor.isTerminated()) {
                this.imageDownloadExecutor.shutdownNow();
                boolean bl = stopped = stopped && this.imageDownloadExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            if (this.imageCacheExecutor != null && !this.imageCacheExecutor.isTerminated()) {
                this.imageCacheExecutor.shutdownNow();
                boolean bl = stopped = stopped && this.imageCacheExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            if (this.unnamedTaskExecutor != null && !this.unnamedTaskExecutor.isTerminated()) {
                this.unnamedTaskExecutor.shutdownNow();
                boolean bl = stopped = stopped && this.unnamedTaskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            if (this.downloadExecutor != null && !this.downloadExecutor.isTerminated()) {
                this.downloadExecutor.shutdownNow();
                boolean bl = stopped = stopped && this.downloadExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            if (!this.mainTaskExecutor.isTerminated()) {
                this.mainTaskExecutor.shutdownNow();
                boolean bl = stopped = stopped && this.mainTaskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            if (!this.scheduler.isTerminated()) {
                this.scheduler.shutdownNow();
                stopped = stopped && this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (stopped) {
            LOGGER.info("All task executors could be stopped");
        } else {
            LOGGER.warn("Could not stop all task executors");
        }
    }

    public boolean isPoolRunning() {
        return this.checkForThreadAlive("tmmpool");
    }

    public boolean isMainTaskRunning() {
        return this.mainTaskExecutor.getActiveCount() > 0 || !this.mainTaskExecutor.getQueue().isEmpty();
    }

    public boolean isImageDownloadsRunning() {
        return this.imageDownloadExecutor.getActiveCount() > 0 || !this.imageDownloadExecutor.getQueue().isEmpty();
    }

    private boolean checkForThreadAlive(String contains) {
        Thread local = Thread.currentThread();
        for (Thread t : this.getAllThreads()) {
            if (t == local || !t.isAlive() || !this.getThreadName(t).contains(contains)) continue;
            return true;
        }
        return false;
    }

    private Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        int nAlloc = root.activeCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    private String getThreadName(Thread t) {
        return t != null && !TmmTaskManager.isEmpty(t.getName()) ? t.getName().toLowerCase(Locale.ROOT) : "";
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.isEmpty();
    }

    @Override
    public void processTaskEvent(TmmTaskHandle task) {
        if (task.getState() == TmmTaskHandle.TaskState.STARTED) {
            this.runningTasks.add(task);
        }
        if (task.getState() == TmmTaskHandle.TaskState.FINISHED || task.getState() == TmmTaskHandle.TaskState.FAILED) {
            this.runningTasks.remove(task);
        }
        for (TmmTaskListener listener : this.taskListener) {
            listener.processTaskEvent(task);
        }
    }

    private class ImageDownloadTaskHandle
    implements TmmTaskHandle {
        private ImageDownloadTaskHandle() {
        }

        @Override
        public String getTaskName() {
            return TmmResourceBundle.getString("task.imagedownloads");
        }

        @Override
        public int getWorkUnits() {
            int unit = 0;
            if (TmmTaskManager.this.imageDownloadExecutor != null) {
                unit = (int)TmmTaskManager.this.imageDownloadExecutor.getTaskCount();
            }
            return unit;
        }

        @Override
        public int getProgressDone() {
            int done = 0;
            if (TmmTaskManager.this.imageDownloadExecutor != null) {
                done = (int)TmmTaskManager.this.imageDownloadExecutor.getCompletedTaskCount();
            }
            return done;
        }

        @Override
        public String getTaskDescription() {
            return this.getOpenTasks() + " " + TmmResourceBundle.getString("task.remaining");
        }

        private int getOpenTasks() {
            int openTasks = 0;
            if (TmmTaskManager.this.imageDownloadExecutor != null) {
                openTasks = TmmTaskManager.this.imageDownloadExecutor.getQueue().size() + TmmTaskManager.this.imageDownloadExecutor.getActiveCount();
            }
            return openTasks;
        }

        @Override
        public TmmTaskHandle.TaskState getState() {
            if (TmmTaskManager.this.imageDownloadHandle != null && this.getOpenTasks() > 0) {
                return TmmTaskHandle.TaskState.STARTED;
            }
            return TmmTaskHandle.TaskState.FINISHED;
        }

        @Override
        public TmmTaskHandle.TaskType getType() {
            return TmmTaskHandle.TaskType.BACKGROUND_TASK;
        }

        @Override
        public void cancel() {
            TmmTaskManager.this.cancelImageDownloads();
            TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageDownloadHandle);
        }

        public String toString() {
            return this.getType().name() + " image " + this.getState().name() + " " + this.getProgressDone() + "/" + this.getWorkUnits();
        }
    }

    private class ImageCacheTaskHandle
    implements TmmTaskHandle {
        private ImageCacheTaskHandle() {
        }

        @Override
        public String getTaskName() {
            return TmmResourceBundle.getString("tmm.rebuildimagecache");
        }

        @Override
        public int getWorkUnits() {
            int unit = 0;
            if (TmmTaskManager.this.imageCacheExecutor != null) {
                unit = (int)TmmTaskManager.this.imageCacheExecutor.getTaskCount();
            }
            return unit;
        }

        @Override
        public int getProgressDone() {
            int done = 0;
            if (TmmTaskManager.this.imageCacheExecutor != null) {
                done = (int)TmmTaskManager.this.imageCacheExecutor.getCompletedTaskCount();
            }
            return done;
        }

        @Override
        public String getTaskDescription() {
            return this.getOpenTasks() + " " + TmmResourceBundle.getString("task.remaining");
        }

        private int getOpenTasks() {
            int openTasks = 0;
            if (TmmTaskManager.this.imageCacheExecutor != null) {
                openTasks = TmmTaskManager.this.imageCacheExecutor.getQueue().size() + TmmTaskManager.this.imageCacheExecutor.getActiveCount();
            }
            return openTasks;
        }

        @Override
        public TmmTaskHandle.TaskState getState() {
            if (TmmTaskManager.this.imageCacheHandle != null && this.getOpenTasks() > 0) {
                return TmmTaskHandle.TaskState.STARTED;
            }
            return TmmTaskHandle.TaskState.FINISHED;
        }

        @Override
        public TmmTaskHandle.TaskType getType() {
            return TmmTaskHandle.TaskType.BACKGROUND_TASK;
        }

        @Override
        public void cancel() {
            TmmTaskManager.this.cancelImageCache();
            TmmTaskManager.this.processTaskEvent(TmmTaskManager.this.imageCacheHandle);
        }

        public String toString() {
            return this.getType().name() + " image " + this.getState().name() + " " + this.getProgressDone() + "/" + this.getWorkUnits();
        }
    }
}

