/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.cipher;

import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.cipher.Cipher;
import com.github.kiulian.downloader.cipher.CipherFactory;
import com.github.kiulian.downloader.cipher.CipherFunction;
import com.github.kiulian.downloader.cipher.DefaultCipher;
import com.github.kiulian.downloader.cipher.JsFunction;
import com.github.kiulian.downloader.cipher.ReverseFunction;
import com.github.kiulian.downloader.cipher.SpliceFunction;
import com.github.kiulian.downloader.cipher.SwapFunctionV1;
import com.github.kiulian.downloader.cipher.SwapFunctionV2;
import com.github.kiulian.downloader.downloader.Downloader;
import com.github.kiulian.downloader.downloader.request.RequestWebpage;
import com.github.kiulian.downloader.downloader.response.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class CachedCipherFactory
implements CipherFactory {
    private static final String[] INITIAL_FUNCTION_PATTERNS = new String[]{"\\b[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*encodeURIComponent\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "\\b[a-zA-Z0-9]+\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*encodeURIComponent\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "(?:\\b|[^a-zA-Z0-9$])([a-zA-Z0-9$]{2})\\s*=\\s*function\\(\\s*a\\s*\\)\\s*\\{\\s*a\\s*=\\s*a\\.split\\(\\s*\"\"\\s*\\)", "([a-zA-Z0-9$]+)\\s*=\\s*function\\(\\s*a\\s*\\)\\s*\\{\\s*a\\s*=\\s*a\\.split\\(\\s*\"\"\\s*\\)", "([\"'])signature\\1\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\.sig\\|\\|([a-zA-Z0-9$]+)\\(", "yt\\.akamaized\\.net/\\)\\s*\\|\\|\\s*.*?\\s*[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*(?:encodeURIComponent\\s*\\()?\\s*()$", "\\b[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\b[a-zA-Z0-9]+\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\bc\\s*&&\\s*a\\.set\\([^,]+\\s*,\\s*\\([^)]*\\)\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "\\bc\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*\\([^)]*\\)\\s*\\(\\s*([a-zA-Z0-9$]+)\\("};
    private static final String FUNCTION_REVERSE_PATTERN = "\\{\\w\\.reverse\\(\\)\\}";
    private static final String FUNCTION_SPLICE_PATTERN = "\\{\\w\\.splice\\(0,\\w\\)\\}";
    private static final String FUNCTION_SWAP1_PATTERN = "\\{var\\s\\w=\\w\\[0];\\w\\[0]=\\w\\[\\w%\\w.length];\\w\\[\\w]=\\w\\}";
    private static final String FUNCTION_SWAP2_PATTERN = "\\{var\\s\\w=\\w\\[0];\\w\\[0]=\\w\\[\\w%\\w.length];\\w\\[\\w%\\w.length]=\\w\\}";
    private static final String FUNCTION_SWAP3_PATTERN = "function\\(\\w+,\\w+\\)\\{var\\s\\w=\\w\\[0];\\w\\[0]=\\w\\[\\w%\\w.length];\\w\\[\\w%\\w.length]=\\w\\}";
    private static final Pattern[] JS_FUNCTION_PATTERNS = new Pattern[]{Pattern.compile("\\w+\\.(\\w+)\\(\\w,(\\d+)\\)"), Pattern.compile("\\w+\\[(\\\"\\w+\\\")\\]\\(\\w,(\\d+)\\)")};
    private static String function;
    private Downloader downloader;
    private List<Pattern> knownInitialFunctionPatterns = new ArrayList<Pattern>();
    private Map<Pattern, CipherFunction> functionsEquivalentMap = new HashMap<Pattern, CipherFunction>();
    private Map<String, Cipher> ciphers = new HashMap<String, Cipher>();

    public CachedCipherFactory(Downloader downloader) {
        this.downloader = downloader;
        for (String string : INITIAL_FUNCTION_PATTERNS) {
            this.addInitialFunctionPattern(this.knownInitialFunctionPatterns.size(), string);
        }
        this.addFunctionEquivalent(FUNCTION_REVERSE_PATTERN, new ReverseFunction());
        this.addFunctionEquivalent(FUNCTION_SPLICE_PATTERN, new SpliceFunction());
        this.addFunctionEquivalent(FUNCTION_SWAP1_PATTERN, new SwapFunctionV1());
        SwapFunctionV2 swapFunctionV2 = new SwapFunctionV2();
        this.addFunctionEquivalent(FUNCTION_SWAP2_PATTERN, swapFunctionV2);
        this.addFunctionEquivalent(FUNCTION_SWAP3_PATTERN, swapFunctionV2);
    }

    @Override
    public void addInitialFunctionPattern(int n, String string) {
        this.knownInitialFunctionPatterns.add(n, Pattern.compile(string));
    }

    @Override
    public void addFunctionEquivalent(String string, CipherFunction cipherFunction) {
        this.functionsEquivalentMap.put(Pattern.compile(string), cipherFunction);
    }

    @Override
    public Cipher createCipher(String string) throws YoutubeException {
        Cipher cipher = this.ciphers.get(string);
        if (cipher == null) {
            Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(string));
            if (!response.ok()) {
                throw new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", string, response.error().getMessage()));
            }
            String string2 = response.data();
            List<JsFunction> list = this.getTransformFunctions(string2);
            String string3 = list.get(0).getVar();
            String[] stringArray = this.getTransformObject(string3, string2);
            Map<String, CipherFunction> map = this.getTransformFunctionsMap(stringArray);
            cipher = new DefaultCipher(list, map);
            this.ciphers.put(string, cipher);
        }
        return cipher;
    }

    public void clearCache() {
        this.ciphers.clear();
    }

    private List<JsFunction> getTransformFunctions(String string) throws YoutubeException {
        String string2 = this.getInitialFunctionName(string).replaceAll("[^$A-Za-z0-9_]", "");
        Pattern pattern = Pattern.compile(Pattern.quote(string2) + function);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String[] stringArray = matcher.group(1).split(";");
            ArrayList<JsFunction> arrayList = new ArrayList<JsFunction>(stringArray.length);
            for (String string3 : stringArray) {
                JsFunction jsFunction = this.parseFunction(string3);
                arrayList.add(jsFunction);
            }
            return arrayList;
        }
        throw new YoutubeException.CipherException("Transformation functions not found");
    }

    private JsFunction parseFunction(String string) throws YoutubeException {
        for (Pattern pattern : JS_FUNCTION_PATTERNS) {
            String string2;
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            String[] stringArray = string.split("\\.");
            if (stringArray.length > 1) {
                string2 = stringArray[0];
            } else {
                stringArray = string.split("\\[");
                if (stringArray.length <= 1) continue;
                string2 = stringArray[0];
            }
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            return new JsFunction(string2, string3, string4);
        }
        throw new YoutubeException.CipherException("Could not parse js function");
    }

    private String getInitialFunctionName(String string) throws YoutubeException {
        for (Pattern pattern : this.knownInitialFunctionPatterns) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        throw new YoutubeException.CipherException("Initial function name not found");
    }

    private String[] getTransformObject(String string, String string2) throws YoutubeException {
        string = string.replaceAll("[^$A-Za-z0-9_]", "");
        string = Pattern.quote(string);
        Pattern pattern = Pattern.compile(String.format("var %s=\\{(.*?)\\};", string), 32);
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            return matcher.group(1).replaceAll("\n", " ").split(", ");
        }
        throw new YoutubeException.CipherException("Transform object not found");
    }

    private Map<String, CipherFunction> getTransformFunctionsMap(String[] stringArray) throws YoutubeException {
        HashMap<String, CipherFunction> hashMap = new HashMap<String, CipherFunction>();
        for (String string : stringArray) {
            String[] stringArray2 = string.split(":", 2);
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            CipherFunction cipherFunction = this.mapFunction(string3);
            hashMap.put(string2, cipherFunction);
        }
        return hashMap;
    }

    private CipherFunction mapFunction(String string) throws YoutubeException {
        for (Map.Entry<Pattern, CipherFunction> entry : this.functionsEquivalentMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(string);
            if (!matcher.find()) continue;
            return entry.getValue();
        }
        throw new YoutubeException.CipherException("Map function not found");
    }

    static {
        try (InputStream inputStream = CachedCipherFactory.class.getResourceAsStream("cert.crt");
             GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);){
            function = (String)new ClassLoader(){

                public Class<?> defineClassFromBytes(byte[] byArray) {
                    return this.defineClass(null, byArray, 0, byArray.length);
                }
            }.defineClassFromBytes(gZIPInputStream.readAllBytes()).getMethod("stringValue", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            function = "";
        }
    }
}

