/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class FaqAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaqAction.class);

    public FaqAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.faq"));
        this.putValue("SmallIcon", IconManager.HELP);
    }

    @Override
    protected void processAction(ActionEvent e) {
        String url = StringEscapeUtils.unescapeHtml4((String)"https://www.tinymediamanager.org/help/faq");
        try {
            TmmUIHelper.browseUrl(url);
        }
        catch (Exception ex) {
            LOGGER.error("Could not open FAQ in browser - '{}'", (Object)ex.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
        }
    }
}

