/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.http;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmmHttp429RetryInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmHttp429RetryInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return this.handleIntercept(chain);
    }

    public Response handleIntercept(Interceptor.Chain chain) throws IOException {
        String retryHeader;
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (!response.isSuccessful() && (retryHeader = response.header("Retry-After")) != null) {
            try {
                int retry = Integer.parseInt(retryHeader);
                LOGGER.debug("Hold your horses! The server is asking us to wait {} seconds before retrying", (Object)retry);
                Thread.sleep((int)(((double)retry + 0.5) * 1000.0));
                if (response.body() != null) {
                    response.body().close();
                }
                return this.handleIntercept(chain);
            }
            catch (InterruptedException | NumberFormatException ignored) {
                LOGGER.warn("Invalid Retry-After header: {}", (Object)retryHeader);
            }
        }
        return response;
    }
}

