/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.util.ArrayList;
import org.jupnp.model.ModelUtil;

public enum RecordQualityMode {
    EP("0:EP"),
    LP("1:LP"),
    SP("2:SP"),
    BASIC("0:BASIC"),
    MEDIUM("1:MEDIUM"),
    HIGH("2:HIGH"),
    NOT_IMPLEMENTED("NOT_IMPLEMENTED");

    private final String protocolString;

    private RecordQualityMode(String protocolString) {
        this.protocolString = protocolString;
    }

    public String toString() {
        return this.protocolString;
    }

    public static RecordQualityMode valueOrExceptionOf(String s) {
        for (RecordQualityMode recordQualityMode : RecordQualityMode.values()) {
            if (!recordQualityMode.protocolString.equals(s)) continue;
            return recordQualityMode;
        }
        throw new IllegalArgumentException("Invalid record quality mode string: " + s);
    }

    public static RecordQualityMode[] valueOfCommaSeparatedList(String s) {
        String[] strings = ModelUtil.fromCommaSeparatedList((String)s);
        if (strings == null) {
            return new RecordQualityMode[0];
        }
        ArrayList<RecordQualityMode> result = new ArrayList<RecordQualityMode>();
        for (String rqm : strings) {
            for (RecordQualityMode recordQualityMode : RecordQualityMode.values()) {
                if (!recordQualityMode.protocolString.equals(rqm)) continue;
                result.add(recordQualityMode);
            }
        }
        return result.toArray(new RecordQualityMode[result.size()]);
    }
}

